#include "Hero.h"

Hero::Hero() {

}

Hero::~Hero() {

}

//initialises the hero's starting column
void Hero::init(int column) {
    _column = column;
}

//draws the hero
void Hero::draw(N5110 &lcd) {

    Vector2D xypos = getxy();
    
    _x = xypos.x;
    _y = xypos.y;
    
    //changes the orientation of the hero depending on the current column
    if (_column < 3 && _column >= 0) {
        lcd.drawRect(_x+4, _y, 6, 2, FILL_BLACK);
        lcd.drawLine(_x+2, _y+1, _x+11, _y+1, 1);
        lcd.drawLine(_x+2, _y+3, _x+3, _y+4, 1);
        lcd.drawLine(_x+11, _y+3, _x+10, _y+4, 1);
        
    } else if (_column < 6 && _column > 2) {
        lcd.drawLine(_x, _y+4, _x, _y+9, 1);
        lcd.drawLine(_x-1, _y+2,_x-1, _y+11, 1);
        lcd.drawLine(_x-3, _y+2, _x-4, _y+3, 1);
        lcd.drawLine(_x-3, _y+11, _x-4, _y+10, 1);
        
    } else if (_column < 9 && _column > 5) {
        lcd.drawLine(_x-4, _y, _x-9, _y, 1);
        lcd.drawLine(_x-2, _y-1, _x-11, _y-1, 1);
        lcd.drawLine(_x-2, _y-3, _x-3, _y-4, 1);
        lcd.drawLine(_x-11, _y-3, _x-10, _y-4, 1);
              
    } else if (_column < 12 && _column > 8) {
        lcd.drawLine(_x, _y-4, _x, _y-9, 1);
        lcd.drawLine(_x+1, _y-2, _x+1, _y-11, 1);
        lcd.drawLine(_x+3, _y-2, _x+4, _y-4, 1);
        lcd.drawLine(_x+3, _y-11, _x+4, _y-10, 1);
    }
}

//sets the column depending on the joystick angle
void Hero::update(float d) {
    
    
    if (d < 0) {
    }   else if (d <= 15) {
        _column = 1;
    }   else if (d <= 45) {
        _column = 2;
    }   else if (d <= 75) {
        _column = 3;
    }   else if (d <= 105) {
        _column = 4;
    }   else if (d <= 135) {
        _column = 5;
    }   else if (d <= 165) {
        _column = 6;
    }   else if (d <= 195) {
        _column = 7;
    }   else if (d <= 225) {
        _column = 8;
    }   else if (d <= 255) {
        _column = 9;
    }   else if (d <= 285) {
        _column = 10;
    }   else if (d <= 315) {
        _column = 11;
    }   else if (d <= 345) {
        _column = 0;
    }   else {
        _column = 1;
    }
    
    
}

//returns the current hero position
Vector2D Hero::getxy() {
    if (_column == 0) {
        Vector2D hero_pos = {21, 1};
        return hero_pos;   
        
    } else if (_column == 1) {
        Vector2D hero_pos = {35, 1};
        return hero_pos;   
        
    } else if (_column == 2) {
        Vector2D hero_pos = {48, 1};
        return hero_pos;  
         
    } else if (_column == 3) {
        Vector2D hero_pos = {64, 3};
        return hero_pos;  
         
    } else if (_column == 4) {
        Vector2D hero_pos = {64, 17};
        return hero_pos;  
         
    } else if (_column == 5) {
        Vector2D hero_pos = {64, 30};
        return hero_pos;   
        
    } else if (_column == 6) {
        Vector2D hero_pos = {62, 46};
        return hero_pos;   
        
    } else if (_column == 7) {
        Vector2D hero_pos = {48, 46};
        return hero_pos;   
        
    } else if (_column == 8) {
        Vector2D hero_pos = {35, 46};
        return hero_pos;   
        
    } else if (_column == 9) {
        Vector2D hero_pos = {19, 44};
        return hero_pos;   
        
    } else if (_column == 10) {
        Vector2D hero_pos = {19, 30};
        return hero_pos;   
        
    } else if (_column == 11) {
        Vector2D hero_pos = {19, 17};
        return hero_pos;
        
    } else {
        Vector2D hero_pos = {0,0};
        return hero_pos;
    } 
}

//returns the current column of the hero
int Hero::get_column() {
    return _column;   
}