#ifndef BULLET_H
#define BULLET_H

// Included Libraries
#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Board.h"


/** Bullet Class
 * @brief Draws and moves the bullets
 * @author Matis Requis
 * @date May, 2020
 */
class Bullet {
public:

    /** Constructor */
    Bullet();
    
    /** Destructor */
    ~Bullet();
    
    /** Initialises the bullet
     * @param column @details column the bullet spawns at
     */
    void init(int column);
    
    /** Draws the bullet
     * @param lcd @details N5110 object
     */
    void draw(N5110 &lcd);
    
    /** Updates the bullet location */
    void update();
    
    /** checks if the bullet needs to be deleted
     * @return 1 or 0 @details returns 1 if bullet needs to be deleted
     */
    int checkdelete();
    
    /** returns a vector with the bullet position
     * @return bulletxy @details Vector2D structure with the bullets xy coordinates
     */
    Vector2D getxy();
    
    /** returns a vector with the bullet lane and position
     * @return bulletxy @details Vector2D structure with the bullets lane and position
     */
    Vector2D getcolumnpos();

private:
    int _column;
    int _x;
    int _y;
    Board _board;
    int _currentpos;
};
#endif