#ifndef BOARD_H
#define BOARD_H

// Included Libraries
#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

#include <algorithm>

/** Board Class
 * @brief Draws the game board and draws the paths the bullets and aliens take
 * @author Matis Requis
 * @date May, 2020
 */
class Board {
public:

    /** Constructor */
    Board();
    
    /** Destructor */
    ~Board();
    
    /** Draws the board
     * @param lcd @details N5110 object
     */
    void draw(N5110 &lcd);
    
    /** Generates a path for each column that the alien and bullet use */
    void path();
    
    /** Function that uses the bresenham line algorithm to generate an array in a line
     * @param x0 @details x coordinate of the first point
     * @param y0 @details y coordinate of the first point
     * @param x1 @details x coordinate of the second point
     * @param y1 @details y coordinate of the second point
     * @param array[14] @details Vector2D array to store the points of the line
     */
    void drawpath(int x0, int y0, int x1, int y1, Vector2D array[14]);
    
    /** Vector2D struct used to store the path */
    Vector2D drawcolumn[12][14];
    
    
};
#endif