#include "Board.h"

Board::Board() {
    
}

Board::~Board() {
    
}

//draws the board
void Board::draw(N5110 &lcd) {
    //outer rectangle
    lcd.drawRect(21, 3, 42, 42, FILL_TRANSPARENT);
    
    //inner rectangle
    lcd.drawRect(34,16,16, 16, FILL_TRANSPARENT);
    
    
    
    //Draw lane Lines
    
    lcd.drawLine(21, 3, 34, 16, 1);
    
    lcd.drawLine(35, 3, 39, 16, 1);
    lcd.drawLine(48,3,44,16,1);
    
    lcd.drawLine(62,3,49,16,1);
    
    lcd.drawLine(62,17,49,21,1);
    lcd.drawLine(62,30,49,26,1);
    
    lcd.drawLine(62,44,49,31,1);
    
    lcd.drawLine(48,44,44,31, 1);
    lcd.drawLine(35,44,39,31, 1);
    
    lcd.drawLine(21,44,34,31,1);
    
    lcd.drawLine(21,30,34,26,1);
    lcd.drawLine(21,17,34,21,1);
}


//calls the bresenham algorithm function for each column and conditions the data
void Board::path() {
    drawpath(28, 3, 37, 16, drawcolumn[0]);
    drawpath(41, 3, 42, 16, drawcolumn[1]);
    
    //columns 2 through 6 need to be flipped because the bresenham algorithm plots lines from left to right
    drawpath(46, 16, 55, 3, drawcolumn[2]);
    int start = 0;
    int end = 13;
    while (start < end) {
        
        //uses a temporary array to flip the main array
        int tempx = drawcolumn[2][start].x;
        drawcolumn[2][start].x = drawcolumn[2][end].x;
        drawcolumn[2][end].x = tempx;
        
        int tempy = drawcolumn[2][start].y;
        drawcolumn[2][start].y = drawcolumn[2][end].y;
        drawcolumn[2][end].y = tempy;
        
        start++;
        end--;   
    }
       
    drawpath(49, 19, 62, 10, drawcolumn[3]);
    start = 0;
    end = 13;
    while (start < end) {
        int tempx = drawcolumn[3][start].x;
        drawcolumn[3][start].x = drawcolumn[3][end].x;
        drawcolumn[3][end].x = tempx;
        
        int tempy = drawcolumn[3][start].y;
        drawcolumn[3][start].y = drawcolumn[3][end].y;
        drawcolumn[3][end].y = tempy;
        
        start++;
        end--;   
    }
    drawpath(49, 23, 62, 24, drawcolumn[4]);
    start = 0;
    end = 13;
    while (start < end) {
        int tempx = drawcolumn[4][start].x;
        drawcolumn[4][start].x = drawcolumn[4][end].x;
        drawcolumn[4][end].x = tempx;
        
        int tempy = drawcolumn[4][start].y;
        drawcolumn[4][start].y = drawcolumn[4][end].y;
        drawcolumn[4][end].y = tempy;
        
        start++;
        end--;   
    }
    drawpath(49, 28, 62, 37, drawcolumn[5]);
    start = 0;
    end = 13;
    while (start < end) {
        int tempx = drawcolumn[5][start].x;
        drawcolumn[5][start].x = drawcolumn[5][end].x;
        drawcolumn[5][end].x = tempx;
        
        int tempy = drawcolumn[5][start].y;
        drawcolumn[5][start].y = drawcolumn[5][end].y;
        drawcolumn[5][end].y = tempy;
        
        start++;
        end--;   
    }
    
    drawpath(46, 31, 55, 44, drawcolumn[6]);
    start = 0;
    end = 13;
    while (start < end) {
        int tempx = drawcolumn[6][start].x;
        drawcolumn[6][start].x = drawcolumn[6][end].x;
        drawcolumn[6][end].x = tempx;
        
        int tempy = drawcolumn[6][start].y;
        drawcolumn[6][start].y = drawcolumn[6][end].y;
        drawcolumn[6][end].y = tempy;
        
        start++;
        end--;   
    }
    
    drawpath(41, 44, 42, 31, drawcolumn[7]);
    drawpath(28, 44, 37, 31, drawcolumn[8]);
    
    drawpath(21, 37, 34, 28, drawcolumn[9]);
    drawpath(21, 23, 34, 24, drawcolumn[10]);
    drawpath(21, 10, 34, 19, drawcolumn[11]);

}


//Bresenham line algorithm to plot a line between 2 points to the and array
//https://en.wikipedia.org/wiki/Bresenham%27s_line_algorithm
void Board::drawpath(int x0, int y0, int x1, int y1, Vector2D array[14]) {
    
    int i = 0;
    int sx;
    int sy;
    int dx = abs(x1 - x0);
    int dy = abs(y1 - y0);
    
    int x = x0;
    int y = y0;
    
    if (x0 > x1) {
        sx = -1;   
    } else { 
        sx = 1;
    }
    
    if (y0 > y1) {
        sy = -1;   
    } else { 
        sy = 1;
    }
    
    if (dx > dy) {
        int err = dx/2;
        while (x != x1) {
            array[i].x = x;
            array[i].y = y;
            err -= dy;
            if (err < 0) {
                y += sy;
                err += dx;   
            }
            x += sx;
            i++;
        }
        
    } else {
        int err = dy/2;
        while (y != y1) {
            array[i].x = x;
            array[i].y = y;
            err -= dx;
            if (err < 0) {
                x += sx;
                err += dy;
            }
            y += sy;
            i++;
        }
    }
    
    array[i].x = x;
    array[i].y = y;
}