#ifndef Alien_H
#define Alien_H

// Included Libraries
#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Board.h"

#include <cstdlib>
#include <ctime>

/** Alien Class
 * @brief Draws and moves the aliens
 * @author Matis Requis
 * @date May, 2020
 */
class Alien {
public:

    /** Constructor */
    Alien();
    
    /** Destructor */
    ~Alien();
    
    /** Initialises the bullet
     * @param column @details column the bullet spawns at
     * @param speed @details speed at which the alien moves lower is faster
     */
    void init(int column, int speed);
    
    
    /** Draws the alien
     * @param lcd @details N5110 object
     */
    void draw(N5110 &lcd);
    
    /** Updates the aliens location */
    void update();
    
    /** checks if the alien needs to be deleted
     * @return 1 or 0 @details returns 1 if alien needs to be deleted
     */
    int checkdelete();
    
    /** checks if the alien need has reached the top of the board */
    int checkobjective();
    
    
    /** returns a vector with the alien position
     * @return alienxy @details Vector2D structure with the aliens xy coordinates
     */
    Vector2D getxy();
    
    /** returns a vector with the alien lane and position
     * @return aliencolpos @details Vector2D structure with the aliens lane and position
     */
    Vector2D getcolumnpos();
    
private:
    int _column;
    int _x;
    int _y;
    Board _board;
    int _currentpos;
    int _rand;
    int _movcount;
    int _alienspeed;
};
#endif