#include "Alien.h"

Alien::Alien() {
    
}

Alien::~Alien() {
    
}

//initialises the alien with all the speed values and the path it uses
void Alien::init(int column, int speed) {
    _currentpos = 13;
    //makes pseudo rando number generator have different seed every time based on the current time
    srand(time(NULL)); 
    _column = column;
    _board.path();
    _alienspeed = speed;
    _movcount = 10;
    
}

//draws the alien
void Alien::draw(N5110 &lcd) {
    getxy();
    
    //draws the alien in differnet orientation depending on the column
    if (_column < 3 && _column >= 0) {
        lcd.drawLine(_x-1, _y, _x+1, _y, 1);
        lcd.drawLine(_x-2, _y+1, _x+2, _y+1, 1);
        
    } else if (_column < 6 && _column > 2) {
        lcd.drawLine(_x, _y-1, _x, _y+1, 1);
        lcd.drawLine(_x-1, _y-2, _x-1, _y+2, 1);
        
    } else if (_column < 9 && _column > 5) {
        lcd.drawLine(_x-1, _y, _x+1, _y, 1);
        lcd.drawLine(_x-2, _y-1, _x+2, _y-1, 1);
              
    } else if (_column < 12 && _column > 8) {
        lcd.drawLine(_x, _y-1, _x, _y+1, 1);
        lcd.drawLine(_x+1, _y-2, _x+1, _y+2, 1);
    }
}

void Alien::update() {
    //advances the alien every x update
    if (_movcount <= 0) {
        
        //random movement can move the alien +1 column, -1 column or not move
        _rand = (rand() % 3)-1;
        _column += _rand;
        
        _currentpos--;
        //resets the speed limiter
        _movcount = _alienspeed;
    } else {
        _movcount--;
    }
        
}

//checks if the alien is at the end of the lane
int Alien::checkdelete() {
    if (_currentpos < 1) {  
        return 1;
    } else {
        return 0;
    }
}

//returns the current position of the alien
Vector2D Alien::getxy() {
    _x = _board.drawcolumn[_column][_currentpos].x;
    _y = _board.drawcolumn[_column][_currentpos].y;

    Vector2D alienxy = {_board.drawcolumn[_column][_currentpos].x, _board.drawcolumn[_column][_currentpos].y};
    return alienxy;
}  

//returns the column and position in the lane of the alien
Vector2D Alien::getcolumnpos() {
    Vector2D aliencolpos = {_column, _currentpos};
    return aliencolpos;   
}