#ifndef SNAKEENGINE_H
#define SNAKEENGINE_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Head.h"
#include "Body.h"
#include "Food.h"

// gap from edge of screen
#define GAP 2

class SnakeEngine
{

public:
    SnakeEngine();
    ~SnakeEngine();

    void init(int head_length,int head_speed, int _food_size, int score);
    void read_input(Gamepad &pad);
    
    void update(Gamepad &pad, N5110 &lcd);
    void draw(N5110 &lcd);
    void gameover(N5110 &lcd, Gamepad &pad);
    
        private:
    int hx;
    int hy;   
    int fx;
    int fy;   
    int _head_length;
    int _head_speed;
    int _score;
    int _nbody;
    int _food_size;
    bool _gameover;
    void collison(Gamepad &pad, N5110 &lcd);
    void eat_food(Gamepad &pad, N5110 &lcd);
    
    Head _h;
    Body _b;
    Food _f;
    Direction _d;
    float _mag;
    

};

#endif