#include "SnakeEngine.h"

// Constructor
SnakeEngine::SnakeEngine()
{

}
// Destructor
SnakeEngine::~SnakeEngine()
{

}

void SnakeEngine::init( int head_length,int head_speed, int food_size, int score)
{
    _nbody = 1;     // Game starts with the body having a head and one body segment 
    _score = score;
    // initialise the game parameters
    _head_length = head_length;
    _head_speed = head_speed;
    _food_size = food_size;
    _h.init(hx, hy, _head_length, _head_speed);
    _f.init();

}

void SnakeEngine::read_input(Gamepad &pad)
{
    _d = pad.get_direction();
     _mag = pad.get_mag();
}
void SnakeEngine::update(Gamepad &pad, N5110 &lcd)
{
    // important to update snake and food before checking collisions so can
    // correct for it before updating the display
     Vector2D hP = _h.get_pos(); 
    _h.update(_d,_mag);
    _b.update(hP, _nbody);
    eat_food(pad, lcd);
    collison(pad, lcd);
    }

void SnakeEngine::draw(N5110 &lcd){
    // drawing map
    lcd.drawRect(0,0,WIDTH,HEIGHT,FILL_TRANSPARENT);
 
    // drawing snake
    _h.draw(lcd);
    _b.draw(lcd, _nbody);
    // drawing food
    _f.draw(lcd);
    
}

// function states that if head position is equal to food position, food respawns and score and size of snake increases by one
void SnakeEngine::eat_food(Gamepad &pad, N5110 &lcd)
{           
    Vector2D _hp = _h.get_pos();    // get head position
    Vector2D _fp = _f.get_pos();    // get food position
if ((_hp.x  == _fp.x && _hp.y == _fp.y)||(_hp.x == _fp.x+1 && _hp.y == _fp.y)||
    (_hp.x  == _fp.x && _hp.y == _fp.y+1)||(_hp.x == _fp.x+1 && _hp.y == _fp.y+1)||
    (_hp.x+1  == _fp.x && _hp.y == _fp.y)||(_hp.x+1 == _fp.x+1 && _hp.y == _fp.y)||
    (_hp.x+1  == _fp.x && _hp.y == _fp.y+1)||(_hp.x+1 == _fp.x+1 && _hp.y == _fp.y+1)||
    (_hp.x  == _fp.x && _hp.y+1 == _fp.y)||(_hp.x == _fp.x+1 && _hp.y+1 == _fp.y)||
    (_hp.x  == _fp.x && _hp.y+1 == _fp.y+1)||(_hp.x == _fp.x+1 && _hp.y+1 == _fp.y+1)){ 
     _score += 1;                   // increase score by 1
    _fp.x = rand() % (WIDTH-3)+1;   // spawns food in a random position inside the map
    _fp.y = rand() % (HEIGHT-3)+1;
    _nbody +=1;                     // increase the number of body segments of snake by 1
    //printf("nbody increases: %d\n", _length_increase);
    _f.init();
    pad.leds_on();
    wait(0.1);
    pad.leds_off();      
    }
}  

// function states that if snake head position with the body of the snake or the map edges, gameover occurs

void SnakeEngine::collison(Gamepad &pad, N5110 &lcd) {
    
    Vector2D _hp = _h.get_pos();    // gets the head position
    Vector2D _bp = _b.get_pos();    // gets the body positions
   
for(int i = 7; i < _nbody; i++)         // use i = 7 since body catches up with the head and gives the player time to move before game over occurs
{                                       
if (_bp.x == _hp.x && _bp.y == _hp.y) {
        //triggers game over
        _gameover = true;
        gameover(lcd, pad);
        //printf("The snake has collided with itself\n");
    }
}
if (_hp.x <= 0) {      // if head x positon is equal or lower
    //triggers game over
    _gameover = true;
    gameover(lcd, pad);
    //prinf("Snake has collided with wall/n");
}        
if (_hp.y <= 0) {      // if head y position is equal or lower
    //triggers game over
    _gameover = true;
    gameover(lcd, pad);
    //prinf("Snake has collided with wall/n");
}
if (_hp.x >= 83) {      // if head x position is equal or exceeds
    //triggers game over
    _gameover = true;
    gameover(lcd, pad);
    //prinf("Snake has collided with wall/n");
}
if (_hp.y >= 47) {      // if head y position is equal or exceeds
    //triggers game over
    _gameover = true;
    gameover(lcd, pad);
    //prinf("Snake has collided with wall/n");
    }
}

void SnakeEngine::gameover(N5110 &lcd, Gamepad &pad) 
{
while(_gameover == true){   // function occurs if collision happens 
    lcd.clear();
    lcd.refresh();
    lcd.printString("   YOU DIED",0,0);
    
char buffer[14];
    sprintf(buffer,"  SCORE = %d", _score);   // Display score
    lcd.printString(buffer,1,1);
    lcd.refresh();
    lcd.setContrast( pad.read_pot1());
    pad.leds_off();
    wait(0.1);
    pad.led(1,1);
    wait(0.1);
    pad.led(2,1);
    wait(0.1);
    pad.led(3,1);
    wait(0.1);
    pad.led(6,1);
    wait(0.1);
    pad.led(5,1);
    wait(0.1);
    pad.led(4,1);
    wait(0.1);
    pad.leds_off();
    }  
}