#include "Head.h"

// Constructor 
Head::Head()
{

}
// Destructor
Head::~Head()
{

}

void Head::init(int x, int y, int length, int speed)
{
    _x = x;
    _y = y;
    _length = length;
    _speed = speed;
    _x = WIDTH/2 - _length/2;  // snake spawns in the centre
    _y = HEIGHT/2 - _length/2;  

   
}
void Head::draw(N5110 &lcd) {
    
    lcd.drawCircle(_x,_y,_length,FILL_BLACK);   // Draw head as a circle
}

void Head::update(Direction d,float mag)
{    
    _x += _velocity.x;              
    _y += _velocity.y;
     
     _speed = int(mag*2.0f);        // Scale is arbitrary
     
if (d == N && d != S) {         // Set the condition so next direction cannot south
    _velocity.y -= _speed;      // Snake moves up
    _velocity.x = 0;            // Ensures that we have Cardinal direction
    pad.led(1,1);
    pad.led(2,0);
    pad.led(3,0);
    pad.led(4,1);
    pad.led(5,0);
    pad.led(6,0);
            }
if (d == S && d != N){          // Set the condition so next direction cannot equal north
    _velocity.y += _speed;      // Snake moves down
    _velocity.x = 0;            // Ensures that we have Cardinal direction       
    pad.led(1,0);
    pad.led(2,0);
    pad.led(3,1);
    pad.led(4,0);
    pad.led(5,0);
    pad.led(6,1);    
            }
if (d == W && d != E){          // Set the condition so next direction cannot equal east   
    _velocity.x -= _speed;      // Snake moves left
    _velocity.y = 0;            // Ensures that we have Cardinal direction
    pad.led(1,0);
    pad.led(2,1);
    pad.led(3,0);
    pad.led(4,0);
    pad.led(5,0);
    pad.led(6,0);
}
if (d == E && d != W){          // Set the condition so next direction cannot equal west     
    _velocity.x += _speed;      //Snake moves right
    _velocity.y = 0;            // Ensures that we have Cardinal direction
    pad.led(1,0);
    pad.led(2,0);
    pad.led(3,0);
    pad.led(4,0);
    pad.led(5,1);
    pad.led(6,0);           
    }  
    /* printf("direction=%i",d);
         printf("head(x)=%i",_x);
         printf("head(y)=%i",_y);
    }*/                
}    
    
Vector2D Head::get_velocity() {
 
    Vector2D v = {_velocity.x, _velocity.y};    //Get the velocity of the head
    return v;
}

Vector2D Head::get_pos() {
    Vector2D pos = {_x,_y};     // Get the position of the head
    return pos;    
}
