/* 
ELEC2645 Embedded Systems Project
School of Electronic & Electrical Engineering
University of Leeds
2019/20

Name: Lee Geer
Username: el18lg
Student ID Number: 201265490
Date: 05/06/2020
*/

// includes
#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "FXOS8700CQ.h"
#include "SnakeEngine.h"



// objects
Gamepad pad;
N5110 lcd;
SnakeEngine snake;

//prototypes 
void init();
void render();
void update();
void welcome();

// function
   int main()
{
#ifdef WITH_TESTING
    //int number_of_failures = run_all_tests();

    //if(number_of_failures > 0) return number_of_failures;
#endif
     int fps = 6;  // frames per second
    
    init();     // initialise and then display welcome screen...
    welcome(); 
    render();  //  draw the initial frame 
    wait(1.0f/fps);  // and wait for one frame period


    // game loop - read input, update the game state and render the display
    while (1) {
        snake.read_input(pad);
        snake.update(pad, lcd); 
        render();
        wait(1.0f/fps);
    }

}
#define head_length 1
#define head_speed 0.5
#define food_size 1
#define score 0

// initialies all classes and libraries
void init()
{

    // need to initialise LCD and Gamepad 
    lcd.init();
    pad.init();
     
    // initialise the game with correct ball and paddle sizes
    snake.init(head_length,head_speed, food_size, score);
     
}


// this function draws each frame on the LCD
void render()
{
    // clear screen, re-draw and refresh
    lcd.clear();  
    snake.draw(lcd);
    lcd.refresh();
}

// this function is introduction
 void welcome() {
    
    lcd.printString("----SNAKE---O",0,1); 
    lcd.printString("  HOLD START  ",0,4);  // instruction to the user
    lcd.refresh();
     
    // wait flashing LEDs until start button is pressed 
while ( pad.start_held() == false) {
    lcd.setContrast( pad.read_pot1());
    pad.leds_off();
    wait(0.1);
    pad.led(1,1);
    wait(0.1);
    pad.led(2,1);
    wait(0.1);
    pad.led(3,1);
    wait(0.1);
    pad.led(6,1);
    wait(0.1);
    pad.led(5,1);
    wait(0.1);
    pad.led(4,1);
    wait(0.1);
    pad.leds_off();
    }

}
     
