/* 
ELEC2645 Embedded Systems Project
School of Electronic & Electrical Engineering
University of Leeds
2019/20

Name: Joshua O'hara
Username: el18jkeo
Student ID Number: 201291390
Date: 11.03.2020
*/
// includes
#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "SpaceInvaderEngine.h"

#define SHIP_WIDTH 9
#define SHIP_HEIGHT 2
#define ALIEN_SIZE 3
#define ROW_SIZE 3
#define COLUMN_SIZE 5
#define COVER_Y 38
#define COVER1_X 9
#define COVER2_X 34
#define COVER3_X 59
#define ROCK_NUMBER 10

// objects
Gamepad pad;
N5110 lcd;
SpaceInvaderEngine SpaceInvader;

// structs
struct UserInput {
    Direction d;
    float mag;
};
    
//functions
void hardware_init();
void game_init();
void draw_game();
void start_menu();
void game_over(int level);
void next_level(int level);
void select_difficulty();
//variables
int _fps;
int _counter;
int _level;
int _difficulty;
int _number_of_aliens;
bool _armada_life;
bool _ship_life;

Direction direction;

int main()
{
    _fps = 6;                                                                   //set frames per second
    _counter = 0;                                                               //game loop counter set to 0 
    _level = 1;                                                                 //level set
    _armada_life = true;                                                        //armada life flag set 
    _ship_life = true;                                                          //ship life flag set
    
    hardware_init();                                                            //initialise gamepad hardware
    start_menu();                                                               //show player the start menu
    select_difficulty();                                                        //show player the difficulty select menu
    
    _number_of_aliens = 5 + 5*_difficulty;                                      //number of aliens increases with difficulty
    
    draw_game();                                                                //draw initial game
    wait(1.0f/_fps);                                                            //wait frame rate
    
    while(1){                                                                   //MAIN LOOP
        hardware_init();                                                        //initialise hardware
        game_init();                                                            //initialise game engine
        next_level(_level);                                                     //show level on screen
        //printf("  level ==  %2d",level);
        
        while(1) {                                                              //LEVEL LOOP
            SpaceInvader.read_input(pad);                                       //read player pad input
            SpaceInvader.update(pad, lcd, _counter, _level);                    //update engine
            draw_game();                                                        //draw updated game
            wait(1.0f/_fps);                                                    //wait frame rate
            _counter++;                                                         //increment counter to show 1 loop completed
            _ship_life = SpaceInvader.get_ship_life();                          //get the ship life 
            if(_ship_life == false){                                            //display game over menu if ship life is false (ship has died)
                game_over(_level);
            }    
            _armada_life = SpaceInvader.get_armada_life();                      //get armada life
            if(_armada_life == false){                                          //break from level loop and progress to next level if armada is dead
                break;
            }
        }
        SpaceInvader.kill_all();                                                //kill all remaining objects from this level
        _level++;                                                               //increment level
        //printf("   counter =  %2d",counter);
    }
}

void start_menu() 
{
    lcd.printString("Space Invaders",0,1);                                      //display start menu
    lcd.printString("  Press Start ",0,4);
    lcd.refresh();
    
    while(pad.start_pressed() == false) {                                       //shows start menu until player presses start
        lcd.setContrast( pad.read_pot1());                                      //set contrast with pad
        pad.leds_on();                                                          //flash LEDs
        wait(0.1);
        pad.leds_off();
        wait(0.1);
    }
}

void draw_game()                                                                //draws game engine
{
    lcd.clear();                                                                //clear previous frame
    SpaceInvader.render(lcd);                                                   //load new frame
    lcd.refresh();                                                              //display new frame
}

void hardware_init()
{ 
    lcd.init();                                                                 //initialise hardware
    pad.init();
}
void game_init()                                                                //initialise game engine and subclasses
{
    SpaceInvader.init(SHIP_HEIGHT,SHIP_WIDTH,ALIEN_SIZE,_number_of_aliens,COLUMN_SIZE,ROW_SIZE,COVER_Y,COVER1_X,COVER2_X,COVER3_X,ROCK_NUMBER,_level);   
}

void game_over(int level)                                                       //game over menu function
{
    lcd.clear();
    pad.leds_on();
    while(1){
        lcd.printString("   Game Over",0,0);                                    //display game over and level until player resets game
        char buffer_[14];
        sprintf(buffer_,"   Level %2d",level);
        lcd.printString(buffer_,0,2);       
        lcd.printString("  Press reset ",0,4);
        lcd.refresh();
    }
}

void next_level(int level)                                                      //next level function
{
    lcd.clear();                                                                //displays upcoming level number
    char buffer_[14];
    sprintf(buffer_,"   Level %2d",level);
    lcd.printString(buffer_,0,2);
    lcd.refresh();
    wait(2);
    lcd.clear();
}
  
void select_difficulty()                                                        //select difficulty function
{
    _difficulty = 1;                                                            //initialise difficulty to 1
    bool select_ = false;                                                       //initialise select flag to false
                                                                                //select flag indicates if A has been pressed
    while(select_ == false){                                                    //run loop while A has not yet been pressed (i.e. a selection has not yet been made)
        lcd.clear();                                                            //prints difficulty options on screen
        lcd.printString("  Easy",0,0);
        lcd.printString("  Medium",0,2);
        lcd.printString("  Hard",0,4);
        switch (_difficulty){                                                   //switch to draw selection box next to the difficulty the player is currently hovering over
            case 1:
                lcd.drawRect(0,0,3,3,FILL_BLACK);
                break;
            case 2:
                lcd.drawRect(0,16,3,3,FILL_BLACK);
                break;
            case 3:
                lcd.drawRect(0,32,3,3,FILL_BLACK);
                break;
            }
        lcd.refresh();
        wait(1);                                                                //wait statement reduces sensitivity of switch making it usable
        
        while(1){    
            direction = pad.get_direction();
            if(pad.A_pressed()==true){                                          //set select flag to true if A is pressed
                select_ = true;
                break;
                }
            if((_difficulty==1)&&                                               //if player is hovering over easy and moves joystick up then hover over hard
            (direction==N)){
                _difficulty = 3;
                break;  
            }
            if((_difficulty==1)&&                                               //if player is hovering over easy and moves joystick down then hover over medium
            (direction==S)){
                _difficulty = 2;
                break;
            }
            if((_difficulty==2)&&                                               //if player is hovering over medium and moves joystick up then hover over easy
            (direction==N)){
                _difficulty = 1; 
                break;  
            }
            if((_difficulty==2)&&                                               //if player is hovering over medium and moves joystick down then hover over hard
            (direction==S)){
                _difficulty = 3;
                break;
            }
            if((_difficulty==3)&&                                               //if player is hovering over hard and moves joystick up then hover over medium
            (direction==N)){
                _difficulty = 2;
                break;
            }
            if((_difficulty==3)&&                                               //if player is hovering over hard and moves joystick down then hover over easy
            (direction==S)){
                _difficulty = 1;
                break;
            }
        }
        //printf("   difficulty %2d",direction);
    }
}
            
    