#ifndef SPACEINVADERENGINE_H
#define SPACEINVADERENGINE_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Ship.h"
#include "Armada.h"
#include "Cover.h"
#include <vector>

#define BORDER 2

/** SpaceInvaderEngine Class
@author Joshua Ohara, el18jkeo, 201291390
@brief Main game engine: checks collsions between objects, updates objects, draws objects
@date May 2020
*/ 

class SpaceInvaderEngine
{

public:
    /**Constructor*/
    SpaceInvaderEngine();
    
    /**Destructor*/
    ~SpaceInvaderEngine();
    
    /**Initialises all objects in game and sets private variables to inputs*/
    void init(int ship_height, int ship_width, int alien_size, int no_aliens, int armada_column_size, int armada_row_size, int cover_y, int cover1_x, int cover2_x, int cover3_x, int no_rocks, int level); //initialise all needed objects and set private member variables
    
    /**Read the gamepad inputs (buttons and joysticks) for use in functions*/
    void read_input(Gamepad &pad);                                              //read the gamepad input (buttons and joystick)
    
    /**Update all objects in game and check for relevant collisions*/
    void update(Gamepad &pad, N5110 &lcd, int counter, int level);              //update all objects 
    
    /**Draw all objects in game*/
    void render(N5110 &lcd);                                                    //draw all objects
    
    /**Check for collision between ship bullets and aliens*/
    void ship_bullet_alien_collision(Gamepad &pad, N5110 &lcd);                 //check for collision between the ship bullets and the aliens
    
    /**Check for collision between ship bullets and cover 1*/
    void ship_bullet_cover1_collision(Gamepad &pad, N5110 &lcd);                //check for collision between the ship bullets and cover 1
    
    /**Check for collision between ship bullets and cover 2*/
    void ship_bullet_cover2_collision(Gamepad &pad, N5110 &lcd);                //check for collision between the ship bullets and cover 2
    
    /**Check for collision between ship bullets and cover 3*/
    void ship_bullet_cover3_collision(Gamepad &pad, N5110 &lcd);                //check for collision between the ship bullets and cover 3
    
    /**Check for collision between alien bullets and player ship*/
    void alien_bullet_ship_collision(Gamepad &pad, N5110 &lcd);                 //check for collision between the alien bullets and the ship
    
    /**Check for collision between alien bullet and cover 3*/
    void alien_bullet_cover3_collision(Gamepad &pad, N5110 &lcd);               //check for collision between the alien bullets and cover 3
    
    /**Check for collision between alien bullet and cover 1*/
    void alien_bullet_cover1_collision(Gamepad &pad, N5110 &lcd);               //check for collision between the alien bullets and cover 1
    
    /**Check for collision between alien bullet and cover 2*/
    void alien_bullet_cover2_collision(Gamepad &pad, N5110 &lcd);               //check for collision between the alien bullets and cover 2
    
    /**Check for collision between aliens and ship*/
    void alien_ship_collision(Gamepad &pad, N5110 &lcd);                        //check for collision between the aliens and the ship
    
    /**Check for collision between aliens and cover 1*/
    void alien_cover1_collision(Gamepad &pad, N5110 &lcd);                      //check for collision between the aliens and cover 1
    
    /**Check for collision between aliens and cover 2*/
    void alien_cover2_collision(Gamepad &pad, N5110 &lcd);                      //check for collision between the aliens and cover 2
    
    /**Check for collision between aliens and cover 3*/
    void alien_cover3_collision(Gamepad &pad, N5110 &lcd);                      //check for collision between the aliens and cover 3
    
    /**Check for collision between player ship and powerup*/
    void ship_powerup_collision(Gamepad &pad, N5110 &lcd);                      //check for collision between player ship and powerup
    
    
    //accessors and mutators//
    
    /**Return the life value of the alien armada
    *@return armada life (bool)
    */
    bool get_armada_life();                                                     //return the life value of the alien armada
    
    /**Return the life value of the ship
    *@return ship life (bool)
    */
    bool get_ship_life();                                                       //return the life value of the ship
    
    /**Set the life/hit value to all remaining objects to true or false repsectively at end of level
    *@param all life/hit value
    */
    void kill_all();                                                            //set life value of all objects to 0
 
private:

    Armada _armada;                                                             //armada (vector of aliens) object
    Ship _ship;                                                                 //ship object
    ShipBulletVector _ship_bullets;                                             //ship bullet vector
    Cover _cover_1;                                                             //cover object (vector of rocks)
    Cover _cover_2;                                                             //cover object (vector of rocks)
    Cover _cover_3;                                                             //cover object (vector of rocks)
    
    int _ship_height;                                                           //height of ship
    int _ship_width;                                                            //width of ship
    int _alien_size;                                                            //size of alien
    int _alien_number;                                                          //number of aliens
    int _armada_column_size;                                                    //number of of aliens per column of armada
    int _armada_row_size;                                                       //number of aliens per row of armada
    bool _powerup;                                                              //ship powerup flag
    
    int _ship_x;                                                                //x position of ship
    int _ship_y;                                                                //y position of ship
    int _cover_y;                                                               //y position of covers
    int _cover_1_x;                                                             //x position of cover 1
    int _cover_2_x;                                                             //x position of cover 2
    int _cover_3_x;                                                             //x position of cover 3
    int _rock_number;                                                           //number of rocks per cover
        
    
    Direction D;                                                                //direction of joystick
    float _mag;                                                                 //magnitude of joystick offset
};

#endif