
#include "SpaceInvaderEngine.h"

SpaceInvaderEngine::SpaceInvaderEngine()
{
}

SpaceInvaderEngine::~SpaceInvaderEngine()
{
}

void SpaceInvaderEngine::init(int ship_height, int ship_width, int alien_size, int no_aliens, int armada_column_size, int armada_row_size, int cover_y, int cover1_x, int cover2_x, int cover3_x, int no_rocks, int level) 
{
    _powerup = false;                                                           //set powerup flag to 0 when level is initialised
    _ship_height = ship_height;                                                 //set ship height as input
    _ship_width = ship_width;                                                   //set ship width as input
    _alien_size = alien_size;                                                   //set alien size and input
    
    Vector2D ship_pos = _ship.get_position();                                   //get the position of the ship
    _ship_x = ship_pos.x;                                                       //set the private variable that holds the ships x position to the ships x position
    _ship_y = ship_pos.y;                                                       //set the private variable that holds the ships y position to the ships y position
    
    _alien_number = no_aliens;                                                  //set alien number
    _armada_column_size = armada_column_size;                                   //set number of aliens in armada column
    _armada_row_size = armada_row_size;                                         //set number of aliens in row of armada
    
    _cover_y = cover_y;                                                         //set the y position of the covers to input value
    _cover_1_x = cover1_x;                                                      //set cover 1 x position to input
    _cover_2_x = cover2_x;                                                      //set cover 2 x position to input
    _cover_3_x = cover3_x;                                                      //set cover 3 x position to input
    _rock_number = no_rocks;                                                    //set number of rocks in each cover
    
    _armada.init(_alien_number,_alien_size,_armada_column_size,_armada_row_size,level);         //initialise armada
    _ship.init(_ship_height,_ship_width);                                       //initialise ship
    _cover_1.init(_cover_1_x,_cover_y,_rock_number);                            //initialise cover 1
    _cover_2.init(_cover_2_x,_cover_y,_rock_number);                            //initialise cover 2
    _cover_3.init(_cover_3_x,_cover_y,_rock_number);                            //initialise cover 3
}
 
void SpaceInvaderEngine::read_input(Gamepad &pad)
{
    D = pad.get_direction();                                                    //get the direction of the joystick
    _mag = pad.get_mag();                                                       //get the magnitude of the offset of the joystick
}
    
void SpaceInvaderEngine::render(N5110 &lcd)
{
    _ship.render(lcd);                                                          //draw the ship
    _armada.render(lcd);                                                        //draw the armada
    _cover_1.render(lcd);                                                       //draw cover 1
    _cover_2.render(lcd);                                                       //draw cover 2
    _cover_3.render(lcd);                                                       //draw cover 3
}

void SpaceInvaderEngine::update(Gamepad &pad, N5110 &lcd, int counter, int level)
{   
    _ship.update(D,_mag,pad,lcd,counter,_powerup);                              //update ship   
    _armada.update(pad, counter, level);                                        //update armada
    ship_bullet_alien_collision(pad, lcd);                                      //check for collision between ship bullets and aliens
    ship_bullet_cover1_collision(pad, lcd);                                     //check for collision between ship bullets and cover 1
    ship_bullet_cover2_collision(pad, lcd);                                     //check for collision between ship bullets and cover 2
    ship_bullet_cover3_collision(pad, lcd);                                     //check for collision between ship bullets and cover 3
    alien_bullet_ship_collision(pad, lcd);                                      //check for collision between alien bullets and ship
    alien_bullet_cover1_collision(pad, lcd);                                    //check for collision between alien bullets and cover 1
    alien_bullet_cover2_collision(pad, lcd);                                    //check for collision between alien bullets and cover 2
    alien_bullet_cover3_collision(pad, lcd);                                    //check for collision between alien bullets and cover 3
    alien_ship_collision(pad, lcd);                                             //check for collision between alien and ship
    alien_cover1_collision(pad, lcd);                                           //check for collision between alien and cover 1
    alien_cover2_collision(pad, lcd);                                           //check for collision between alien and cover 2
    alien_cover3_collision(pad, lcd);                                           //check for collision between alien and cover 3
    ship_powerup_collision(pad, lcd);                                           //check for collision between ship and powerup
}

void SpaceInvaderEngine::ship_bullet_alien_collision(Gamepad &pad, N5110 &lcd)
{
    vector<Alien> alien_vector_ = _armada.get_vector();                         //get copy of alien vector
    vector<ShipBullet> bullet_vector_ = _ship.get_bullet_vector();              //get copy of ship bullet vector
    for(int i = 0; i < alien_vector_.size(); i++){                              //iterate through alien vector 
        Vector2D alien_position_ = alien_vector_[i].get_position();             //get alien i's position
        int alien_x_ = alien_position_.x;                                       //copy alien i's x position to function variable
        int alien_y_ = alien_position_.y;                                       //copy alien i's y position to function variable
        bool alien_life_ = alien_vector_[i].get_life();                         //copy alien i's life value to function variable
        for (int n = 0; n < bullet_vector_.size(); n++){                        //iterate through bullet vector
            Vector2D bullet_position_ = bullet_vector_[n].get_position();       //get bullet n's position
            int bullet_x_ = bullet_position_.x;                                 //copy bullet n's x position to function variable
            int bullet_y_ = bullet_position_.y;                                 //copy bullet n's y position to function variable
            bool hit_ = bullet_vector_[n].get_hit();                            //copy bullet n's hit value to function variable
            if((alien_x_ <= bullet_x_) &&                                       //check to see if bullet n is inside alien i
            (bullet_x_ <= alien_x_ + _alien_size)&&
            (alien_y_ <= bullet_y_) &&
            (bullet_y_ <= alien_y_ + _alien_size)&&
            (hit_==false)&&                                                     //check to see if the bullet has not yet caused a hit
            (alien_life_ == true)) {                                            //check to see if alien is alive
                _armada.set_life(i,false);                                      //if alien is alive, bullet has not caused a hit and bullet is inside alien, set hit value of bullet to true and life value of alien to false
                _ship.set_bullet_hit(n,true);
                pad.tone(600.0,0.4);                                            //make pad tone to indicate collision
            //printf("collision");
            }
        }
    }
}

void SpaceInvaderEngine::ship_bullet_cover1_collision(Gamepad &pad, N5110 &lcd)
{
    vector<Rock> cover_vector_1_ = _cover_1.get_vector();                       //copy cover 1 vector 
    vector<ShipBullet> bullet_vector_ = _ship.get_bullet_vector();              //copy ship bullet vector
    for(int i = 0; i < cover_vector_1_.size(); i++){                            //iterate through cover vector
        Vector2D rock_position_ = cover_vector_1_[i].get_position();            //get rock i's position
        int rock_x_ = rock_position_.x;                                         //copy rock i's x position to function variable
        int rock_y_ = rock_position_.y;                                         //copy rock i's y position to function variable
        bool rock_life_ = cover_vector_1_[i].get_life();                        //copy rock i's life value to function variable
        for (int n = 0; n < bullet_vector_.size(); n++){                        //iterate through ship bullet vector
            Vector2D bullet_position_ = bullet_vector_[n].get_position();       //get ship bullet n's position
            int bullet_x_ = bullet_position_.x;                                 //copy ship bullet n's x position to function variable
            int bullet_y_ = bullet_position_.y;                                 //copy ship bullet n's y position to function variable
            bool hit_ = bullet_vector_[n].get_hit();                            //copy ship bullet n's hit value to function variable
            if((rock_x_ <= bullet_x_) &&                                        //check to see if bullet n is inside rock i
            (bullet_x_ <= rock_x_ + 2)&&
            (rock_y_ <= bullet_y_) &&
            (bullet_y_ <= rock_y_ + 2)&&
            (hit_==false)&&                                                     //check to see if bullet n's hit value is false
            (rock_life_==true)){                                                //check to see if rock i's life value is true
                _cover_1.set_life(i,false);                                     //if bullet is inside rock, rock is alive and bullet has not yet caused a hit, set hit value to true, and life value to false
                _ship.set_bullet_hit(n,true);                       
                pad.tone(700.0,0.4);                                            //pad tone to indicate collision
            }
        }
    }
}

void SpaceInvaderEngine::ship_bullet_cover2_collision(Gamepad &pad, N5110 &lcd)
{
    vector<Rock> cover_vector_2_ = _cover_2.get_vector();                       //copy cover 2 vector 
    vector<ShipBullet> bullet_vector_ = _ship.get_bullet_vector();              //copy ship bullet vector
    for(int i = 0; i < cover_vector_2_.size(); i++){                            //iterate through cover vector
        Vector2D rock_position_ = cover_vector_2_[i].get_position();            //get rock i's position
        int rock_x_ = rock_position_.x;                                         //copy rock i's x position to function variable
        int rock_y_ = rock_position_.y;                                         //copy rock i's y position to function variable
        bool rock_life_ = cover_vector_2_[i].get_life();                        //copy rock i's life value to function variable
        for (int n = 0; n < bullet_vector_.size(); n++){                        //iterate through ship bullet vector
            Vector2D bullet_position_ = bullet_vector_[n].get_position();       //get ship bullet n's position
            int bullet_x_ = bullet_position_.x;                                 //copy bullet n's x position to function variable
            int bullet_y_ = bullet_position_.y;                                 //copy bullet n's y position to function variable
            bool hit_ = bullet_vector_[n].get_hit();                            //copy bullet n's hit value to function variable
            if((rock_x_ <= bullet_x_) &&                                        //check to see if bullet n is inside rock i
            (bullet_x_ <= rock_x_ + 2)&&
            (rock_y_ <= bullet_y_) &&
            (bullet_y_ <= rock_y_ + 2)&&
            (hit_==false)&&                                                     //check to see if bullet n's hit value is false
            (rock_life_==true)){                                                //check to see if rock i's life value is true
                _cover_2.set_life(i,false);                                     //if the bullet is inside of the rock, the rock is alive and the bullet has not yet cuased a hit, set the rock life to false and the bullet's hit value to true
                _ship.set_bullet_hit(n,true);
                pad.tone(700.0,0.4);                                            //pad tone to indicate collision
            }
        }
    }
}

void SpaceInvaderEngine::ship_bullet_cover3_collision(Gamepad &pad, N5110 &lcd)
{
    vector<Rock> cover_vector_3_ = _cover_3.get_vector();                       //copy cover 3 vector
    vector<ShipBullet> bullet_vector_ = _ship.get_bullet_vector();              //copy ship bullet vector
    for(int i = 0; i < cover_vector_3_.size(); i++){                            //iterate through cover vector
        Vector2D rock_position_ = cover_vector_3_[i].get_position();            //get rock i's position
        int rock_x_ = rock_position_.x;                                         //copy rock i's x position to function variable
        int rock_y_ = rock_position_.y;                                         //copy rock i's y position to function variable
        bool rock_life_ = cover_vector_3_[i].get_life();                        //copy rock i's life value to function variable
        for (int n = 0; n < bullet_vector_.size(); n++){                        //iterate through ship bullet vector
            Vector2D bullet_position_ = bullet_vector_[n].get_position();       //get bullet n's position
            int bullet_x_ = bullet_position_.x;                                 //copy bullet n's x position to function variable
            int bullet_y_ = bullet_position_.y;                                 //copy bullet n's y position to function variable
            bool hit_ = bullet_vector_[n].get_hit();                            //copy bullet n's hit value to function variable
            if((rock_x_ <= bullet_x_) &&                                        //check to see if bullet n is inside rock i
            (bullet_x_ <= rock_x_ + 2)&&
            (rock_y_ <= bullet_y_) &&
            (bullet_y_ <= rock_y_ + 2)&&
            (hit_==false)&&                                                     //check to see if bullet n has caused a hit
            (rock_life_==true)){                                                //check to see if rock i is alive
                _cover_3.set_life(i,false);                                     //if the bullet is inside of the rock, the rock is alive and the bullet has not yet cuased a hit, set the rock life to false and the bullet's hit value to true
                _ship.set_bullet_hit(n,true);
                pad.tone(700.0,0.4);                                            //pad tone to indicate collision
            //printf("collision");
            }   
        }
    }
}

void SpaceInvaderEngine::alien_bullet_ship_collision(Gamepad &pad, N5110 &lcd)
{
    Vector2D ship_position_ = _ship.get_position();                             //get ship position
    int ship_x_ = ship_position_.x;                                             //copy ship x position to function variable
    int ship_y_ = ship_position_.y;                                             //copy ship y position to function variable
    vector<Alien> alien_vector_ = _armada.get_vector();                         //get copy of armada vector
    for(int i = 0; i < alien_vector_.size(); i++){                              //iterate through armada vector
        vector<AlienBullet> alien_bullets_ = _armada.get_alien_bullet_vector(i);//get the alien bullet vector of alien i in the armada
        for(int n = 0; n < alien_bullets_.size(); n++){                         //iterate through the bullets in alien i's bullet vector
            Vector2D bullet_position_ = alien_bullets_[n].get_position();       //get the position of bullet n in alien i's bullet vector
            bool hit_ = alien_bullets_[n].get_hit();                            //copy the hit value of bullet n in alien i's bullet vector to function variable
            int bullet_x_ = bullet_position_.x;                                 //copy the x position of bullet n in alien i's bullet vector
            int bullet_y_ = bullet_position_.y;                                 //copy the y position of bullet n in alien i's bullet vector
            if((ship_x_ <= bullet_x_) &&                                        //check to see if bullet n in alien i's bullet vector is inside the ship
            (bullet_x_ <= ship_x_ + _ship_width)&&
            (ship_y_ <= bullet_y_) &&
            (bullet_y_ <= ship_y_ + _ship_height)&&
            (hit_==false)){                                                     //check to see if bullet n in alien i's bullet vector has caused a collision
                _ship.set_life(false);                                          //if bullet is inside ship, and bullet has not yet caused a hit, set bullet's hit value to true and ships life value to false
                alien_bullets_[n].set_hit(true);                               
                pad.tone(600.0,0.5);                                            //pad tone to indicate death
            //printf("collision");
            }
        }
    }
}

void SpaceInvaderEngine::alien_bullet_cover3_collision(Gamepad &pad, N5110 &lcd)
{
    vector<Rock> cover_vector_3_ = _cover_3.get_vector();                       //get cover 3 vector
    vector<Alien> alien_vector_ = _armada.get_vector();                         //get alien armada vector
       for(int q = 0; q < cover_vector_3_.size(); q++){                         //iterate through every rock in cover 3
        Vector2D rock_position_ = cover_vector_3_[q].get_position();            //get rock q's position 
        int rock_x_ = rock_position_.x;                                         //copy rock q's x position to function variable
        int rock_y_ = rock_position_.y;                                         //copy rock q's y position to function variable
        bool rock_life_ = cover_vector_3_[q].get_life();                        //copy rock q's life value to function variable
        for(int i = 0; i < alien_vector_.size(); i++){                          //iterate through alien armada vector
        vector<AlienBullet> alien_bullets_ = _armada.get_alien_bullet_vector(i);//get the alien bullet vector of alien i
            for(int n = 0; n < alien_bullets_.size(); n++){                     //iterate through alien i's bullet vector
                Vector2D bullet_position_ = alien_bullets_[n].get_position();   //get bullet n in alien i's vector, position
                bool hit_ = alien_bullets_[n].get_hit();                        //get the hit value of bullet n in alien i's vector
                int bullet_x_ = bullet_position_.x;                             //copy bullet n in alien i's vector's x position to a function variable
                int bullet_y_ = bullet_position_.y;                             //copy bullet n in alien i's vector's y position to a function variable
                if((rock_x_ <= bullet_x_) &&                                    //check to see if bullet is inside rock
                    (bullet_x_ <= rock_x_ + 2)&&
                    (rock_y_ <= bullet_y_) &&
                    (bullet_y_ <= rock_y_ + 2)&&
                    (hit_==false)&&                                             //check to see if bullet has caused a hit yet
                    (rock_life_==true)){                                        //check to see if rock is alive
                    _cover_3.set_life(q,false);                                 //if rock has not been hit and bullet has not caused a hit, set rock's life to false and bullet's hit to true
                    _armada.set_bullet_hit(i,n,true);
                    pad.tone(700.0,0.4);                                        //pad tone to indicate collision
                }
            }
        }
    }
}

void SpaceInvaderEngine::alien_bullet_cover1_collision(Gamepad &pad, N5110 &lcd)
{
    vector<Rock> cover_vector_1_ = _cover_1.get_vector();                       //get copy of cover 1 vector
    vector<Alien> alien_vector_ = _armada.get_vector();                         //get copy of alien armada vector
       for(int q = 0; q < cover_vector_1_.size(); q++){                         //iterate through each rock in the cover vector
        Vector2D rock_position_ = cover_vector_1_[q].get_position();            //get the position of rock q
        int rock_x_ = rock_position_.x;                                         //copy rock q's x position to function variable
        int rock_y_ = rock_position_.y;                                         //copy rock q's y position to function variable
        bool rock_life_ = cover_vector_1_[q].get_life();                        //copy rock q's life value to function variable
        for(int i = 0; i < alien_vector_.size(); i++){                          //iterate through alien armada vector
        vector<AlienBullet> alien_bullets_ = _armada.get_alien_bullet_vector(i);//get alien i's bullet vector
            for(int n = 0; n < alien_bullets_.size(); n++){                     //iterate through alien i's bullet vector
                Vector2D bullet_position_ = alien_bullets_[n].get_position();   //get bullet n in alien i's bullet vector's position
                bool hit_ = alien_bullets_[n].get_hit();                        //copy bullet n in alien i's bullet vector's hit value to function variable
                int bullet_x_ = bullet_position_.x;                             //copy bullet n in alien i's bullet vector's x position to function variable
                int bullet_y_ = bullet_position_.y;                             //copy bullet n in alien i's bullet vector's x position to function variable
                if((rock_x_ <= bullet_x_) &&                                    //check to see if bullet n in alien i's bullet vector is inside rock q
                (bullet_x_ <= rock_x_ + 2)&&
                (rock_y_ <= bullet_y_) &&
                (bullet_y_ <= rock_y_ + 2)&&
                (hit_==false)&&                                                 //check to make sure bullet has not yet caused a hit
                (rock_life_==true)){                                            //check to make sure rock is alive
                    _cover_1.set_life(q,false);                                 //if rock has not been hit and bullet has not caused a hit, set rock's life to false and bullet's hit to true
                    _armada.set_bullet_hit(i,n,true);
                    pad.tone(700.0,0.4);                                        //pad tone to indicate collision
                //printf("collision");    
                }
            }
        }
    }
}

void SpaceInvaderEngine::alien_bullet_cover2_collision(Gamepad &pad, N5110 &lcd)
{
    vector<Rock> cover_vector_2_ = _cover_2.get_vector();                       //get cover 2 vector
    vector<Alien> alien_vector_ = _armada.get_vector();                         //get armada vector
        for(int q = 0; q < cover_vector_2_.size(); q++){                        //iterate through each rock in cover vector
        Vector2D rock_position_ = cover_vector_2_[q].get_position();            //get rock q's position
        int rock_x_ = rock_position_.x;                                         //copy rock q's x position to function variable
        int rock_y_ = rock_position_.y;                                         //copy rock q's y position to function variable
        bool rock_life_ = cover_vector_2_[q].get_life();                        //copy rock q's life value to function variable
            for(int i = 0; i < alien_vector_.size(); i++){                      //iterate through each alien in armada
            vector<AlienBullet> alien_bullets_ = _armada.get_alien_bullet_vector(i);    //get alien i's bullet vector 
                for(int n = 0; n < alien_bullets_.size(); n++){                         //iterate through alien i's bullet vector
                    Vector2D bullet_position_ = alien_bullets_[n].get_position();       //get bullet n in alien i's vector's position
                    bool hit_ = alien_bullets_[n].get_hit();                            //get bullet n in alien i's vector's hit value
                    int bullet_x_ = bullet_position_.x;                                 //copy bullet n in alien i's vector's x position to function variable
                    int bullet_y_ = bullet_position_.y;                                 //copy bullet n in alien i's vector's y position to function variable
                    if((rock_x_ <= bullet_x_) &&                                //check to see if bullet is inside rock
                    (bullet_x_ <= rock_x_ + 2)&&
                    (rock_y_ <= bullet_y_) &&
                    (bullet_y_ <= rock_y_ + 2)&&
                    (hit_==false)&&                                             //check to see if bullet has caused a hit yet
                    (rock_life_==true)){                                        //check to see if rock is alive
                        _cover_2.set_life(q,false);                             //if rock has not been hit and bullet has not caused a hit, set rock's life to false and bullet's hit to true
                        _armada.set_bullet_hit(i,n,true);
                        pad.tone(700.0,0.4);                                    //pad tone to indicate collision
                }
            }
        }
    }
}

void SpaceInvaderEngine::alien_ship_collision(Gamepad &pad, N5110 &lcd)
{
    Vector2D ship_position_ = _ship.get_position();                             //get ship position
    int ship_x_ = ship_position_.x;                                             //copy ship x position to function variable
    int ship_y_ = ship_position_.y;                                             //copy ship y position to function variable
    vector<Alien> alien_vector_ = _armada.get_vector();                         //get alien vector
    for(int i = 0; i < alien_vector_.size(); i++){                              //iterate through alien vector
        Vector2D alien_position_ = alien_vector_[i].get_position();             //get position of alien i
        int alien_x_ = alien_position_.x;                                       //copy alien i's x position to function variable
        int alien_y_ = alien_position_.y;                                       //copy alien i's y position to function variable
        for(int q = 0; q < _alien_size; q++){                                   //iterate through each pixel of alien i
            for(int n = 0; n < _alien_size; n++){                               
                if((ship_x_ - 1 < alien_x_ + q) &&                              //check to see if alien is inside ship
                (ship_x_ + 9 > alien_x_ + q)&&
                (ship_y_ - 1 < alien_y_ + n)&&
                (_ship.get_life()==true)&&                                      //check to see if ship is alive
                (_armada.get_life(i)==true)){                                   //check to see if alien is alive
                    _ship.set_life(false);                                      //set ship life to false if 
                    _armada.set_life(i,false);                                  //set alien life to false
                    pad.tone(600.0,0.5);                                        //pad tone to indicate death
                }
            }
        }
    }
}


void SpaceInvaderEngine::alien_cover1_collision(Gamepad &pad, N5110 &lcd)
{
    vector<Alien> alien_vector_ = _armada.get_vector();                         //get alien vector
    vector<Rock> cover_1_ = _cover_1.get_vector();                              //get cover 1 vector
    for(int i = 0; i < alien_vector_.size(); i++){                              //iterate through alien vector
        Vector2D alien_position_ = alien_vector_[i].get_position();             //get alien i's position
        int alien_x_ = alien_position_.x;                                       //copy alien i's x position to function variable
        int alien_y_ = alien_position_.y;                                       //copy alien i's y position to function variable
        for(int p = 0; p < cover_1_.size(); p++){                               //iterate through cover
            Vector2D rock_position_ = cover_1_[p].get_position();               //get position of rock p in cover vector
            int rock_x_ = rock_position_.x;                                     //copy rock x position to function variable
            int rock_y_ = rock_position_.y;                                     //copy rock y position to function variable
            for(int q = 0; q < _alien_size; q++){                               //iterate through each pixel of alien
                for(int s = 0; s < _alien_size; s++){
                    if((rock_x_ < alien_x_ + q) &&                              //check to see if alien is inside of rock
                    (rock_x_ + 2 > alien_x_ + q)&&
                    (rock_y_ < alien_y_ + s)&&
                    (rock_y_ + 2 > alien_y_ + s)&&
                    (_cover_1.get_life(p)==true)&&                              //check to see if rock is alive
                    (_armada.get_life(i)==true)){                               //check to see if alien is alive
                        _cover_1.set_life(p,false);                             //if alien and rock alive and collision has occured then set alien and rock life to false
                        _armada.set_life(i,false);
                        pad.tone(700.0,0.4);                                    //pad tone to indicate collsion
                    ////printf("collision");    
                    }
                }
            }
        }
    }
}

void SpaceInvaderEngine::alien_cover2_collision(Gamepad &pad, N5110 &lcd)
{
    vector<Alien> alien_vector_ = _armada.get_vector();                         //get alien vector
    vector<Rock> cover_2_ = _cover_2.get_vector();                              //get cover 2 vector
    for(int i = 0; i < alien_vector_.size(); i++){                              //iterate through alien vector
        Vector2D alien_position_ = alien_vector_[i].get_position();             //get alien i's position
        int alien_x_ = alien_position_.x;                                       //copy alien i's x position to function variable
        int alien_y_ = alien_position_.y;                                       //copy alien i's y position to function variable
        for(int p = 0; p < cover_2_.size(); p++){                               //iterate through each rock in cover 2 vector
            Vector2D rock_position_ = cover_2_[p].get_position();               //get rock p's postition
            int rock_x_ = rock_position_.x;                                     //copy rock p's x position to function variable
            int rock_y_ = rock_position_.y;                                     //copy rock p's y position to function variable
            for(int q = 0; q < _alien_size; q++){                               //iterate through each pixel of alien
                for(int s = 0; s < _alien_size; s++){
                    if((rock_x_ < alien_x_ + q) &&                              //check to see if alien is inside rock
                    (rock_x_ + 2 > alien_x_ + q)&&
                    (rock_y_ < alien_y_ + s)&&
                    (rock_y_ + 2 > alien_y_ + s)&&
                    (_cover_2.get_life(p)==true)&&                              //check to see if rock is alive
                    (_armada.get_life(i)==true)){                               //check to see if alien is alive
                        _cover_2.set_life(p,false);                             //if alien and rock alive and collision has occured then set alien and rock life to false
                        _armada.set_life(i,false);
                        pad.tone(700.0,0.4);                                    //pad tone to indicate collision
                    //printf("collision");    
                    }
                }
            }
        }
    }
}

void SpaceInvaderEngine::alien_cover3_collision(Gamepad &pad, N5110 &lcd)
{
    vector<Alien> alien_vector_ = _armada.get_vector();                         //get alien vector
    vector<Rock> cover_3_ = _cover_3.get_vector();                              //get cover vector
    for(int i = 0; i < alien_vector_.size(); i++){                              //iterate through alien vector
        Vector2D alien_position_ = alien_vector_[i].get_position();             //get position of alien i in vector
        int alien_x_ = alien_position_.x;                                       //copy x position of alien i to function variable
        int alien_y_ = alien_position_.y;                                       //copy y position of alien i to function variable
        for(int p = 0; p < cover_3_.size(); p++){                               //iterate through each rock in cover vector
            Vector2D rock_position_ = cover_3_[p].get_position();               //get position of rock p
            int rock_x_ = rock_position_.x;                                     //copy x position of rock to function variable
            int rock_y_ = rock_position_.y;                                     //copy y position of rock to function variable
            for(int q = 0; q < _alien_size; q++){                               //iterate through each pixel of alien
                for(int s = 0; s < _alien_size; s++){
                    if((rock_x_ < alien_x_ + q) &&                              //check to see if alien is inside rock
                    (rock_x_ + 2 > alien_x_ + q)&&
                    (rock_y_ < alien_y_ + s)&&
                    (rock_y_ + 2 > alien_y_ + s)&&
                    (_cover_3.get_life(p)==true)&&                              //check to make sure rock is alive
                    (_armada.get_life(i)==true)){                               //check to make sure alien is alive
                        _cover_3.set_life(p,false);                             //if alien and rock alive and collision has occured then set alien and rock life to false
                        _armada.set_life(i,false);
                        pad.tone(700.0,0.4);                                    //pad tone to indicate collision
                    //printf("collision");    
                    }
                }
            }
        }
    }
}

bool SpaceInvaderEngine::get_armada_life()
{
    return _armada.get_armada_life();                                           //return armada life to main.cpp
}

bool SpaceInvaderEngine::get_ship_life()
{
    return _ship.get_life();                                                    //return ship life to main.cpp
}
    
void SpaceInvaderEngine::kill_all()
{
    vector<Rock> cover_vector_1_ = _cover_1.get_vector();                       //get cover vector 1
    vector<Rock> cover_vector_2_ = _cover_2.get_vector();                       //get cover vector 2
    vector<Rock> cover_vector_3_ = _cover_3.get_vector();                       //get cover vector 3
    for(int i = 0; i < cover_vector_1_.size(); i++){                            //iterate through cover vectors
        _cover_1.set_life(i,false);                                             //set life of each rock to false in cover 1
        _cover_2.set_life(i,false);                                             //set life of each rock to false in cover 2
        _cover_3.set_life(i,false);                                             //set life of each rock to false in cover 3
    }
    vector<ShipBullet> ship_bullet_vector_ = _ship.get_bullet_vector();         //get ship bullet vector
    for(int n = 0; n < ship_bullet_vector_.size(); n++){                        //iterte through ship bullet vector
        _ship.set_bullet_hit(n,true);                                           //set hit value of each bullet to true
    }
    vector<Alien> alien_vector_ = _armada.get_vector();                         //get alien vector
    for(int p = 0; p < alien_vector_.size(); p++){                              //iterate through alien vector
        vector<AlienBullet> alien_bullets_ = _armada.get_alien_bullet_vector(p);//get alien p's bullet vector
        for(int q = 0; q < alien_bullets_.size(); q++){                         //iterate through alien p's bullet vector
            _armada.set_bullet_hit(p,q,true);                                   //set bullet q in alien p's vector's hit value to true
            _armada.set_alien_powerup_hit(p,true);                              //set alien p's powerup hit value to true
        }
    }
    _ship.set_life(false);                                                      //set ship life value to false
    _powerup = false;                                                           //set powerup flag to false
    //printf("   powerup = "%d, _powerup);
}

void SpaceInvaderEngine::ship_powerup_collision(Gamepad &pad, N5110 &lcd)
{
    vector<Alien> alien_vector_ = _armada.get_vector();                         //get alien vector
    Vector2D ship_position_ = _ship.get_position();                             //get ship position
    int ship_x_ = ship_position_.x;                                             //copy ship x position to function variable
    int ship_y_ = ship_position_.y;                                             //copy ship y position to function variable
    for(int i = 0; i < alien_vector_.size(); i++){                              //iterate through alien vector
        Vector2D powerup_position_ = alien_vector_[i].get_powerup_position();   //get the position of alien i's powerup
        int powerup_x_ = powerup_position_.x;                                   //copy the x position of alien i's powerup to function variable
        int powerup_y_ = powerup_position_.y;                                   //copy the y position of alien i's powerup to function variable
        bool hit_ = alien_vector_[i].get_powerup_hit();                         //copy the hit value of alien i's powerup to function variable
        for(int q = 0; q < 3; q++){                                             //iterate through each pixel of powerup
            for(int n = 0; n < 3; n++){                                     
                if((ship_x_ - 1 < powerup_x_ + q) &&                            //check to see if powerup is inside ship
                (ship_x_ + 9 > powerup_x_ + q)&&
                (ship_y_ - 1 < powerup_y_ + n)&&
                (hit_ == false)){                                               //check to see if powerup has had previous collision
                    _armada.set_alien_powerup_hit(i,true);                      //if ship hits powerup and powerup has not yet caused a hit, set powerup hit to true and powerup flag to true
                    _powerup = true;
                    pad.tone(600.0,0.5);                                        //pad tone to indicate collision
                    ////printf("collision");               
                }
            }
        }
    }
}
