#include "ShipBulletVector.h"

ShipBulletVector::ShipBulletVector()
{
}

ShipBulletVector::~ShipBulletVector()
{
}

void ShipBulletVector::init() 
{
    _shoot = true;                                                              //allow player to shoot from start
    _old_counter = 0;                                                           //set old counter to 0 for use later
    _powerup = false;
}

void ShipBulletVector::render(N5110 &lcd) 
{
    for (unsigned int i =0; i < _bullet_vector.size(); i++) {                   //draw all bullets in the bullet vector
        _bullet_vector[i].render(lcd);
    }
}

void ShipBulletVector::update(Gamepad &pad, N5110 &lcd, int ship_x, int ship_y, int counter, bool powerup) 
{
    _powerup = powerup;
    _x = ship_x;                                                                //set the x position of any new bullet to the x position of the ship
    _y = ship_y;                                                                //set the y position of any new bullet to the y position of the ship
    int counter_ = counter;                                                     //copy counter variable for use inside the function
    flag_set(counter_);                                                         //run flag set function to see if enough time has passed ot shoot again
    if((pad.A_pressed()==true)&&                                                //shoot if player pressed a and shoot flag is true
    (_shoot == true)) {
        pad.tone(800.0,0.1);                                                    //make shoot noise                                                     
        ShipBullet new_bullet;                                                  //create new bullet object
        new_bullet.init(_x,_y);                                                 //initialise this new bullet
        _bullet_vector.push_back(new_bullet);                                   //add this new bullet to the vector of ship bullets
        _shoot = false;                                                         //set the shoot flag to false
        _old_counter = counter_;                                                //copy counter to old counter for use in next loop
        }
    for (int i = 0; i < _bullet_vector.size(); i++) {                           //update the bullets in the vector of bullets
        _bullet_vector[i].update(pad,lcd);
    }
}

vector<ShipBullet> ShipBulletVector::get_vector() 
{
    vector<ShipBullet> v = _bullet_vector;                                      //return a copy of the bullet vector
    return v;
}
    
void ShipBulletVector::set_hit(int i, bool x)
{
    _bullet_vector[i].set_hit(x);                                                //set the hit value of bullet i in the vector
}

void ShipBulletVector::flag_set(int counter)
{
    int flag_counter_ = counter;  
    if(_powerup == false){                                                      //set shoot flag to true 4 game loops (2/3 seconds) after last shot if no powerup collected 
        if (_old_counter + 4 <= flag_counter_) {                
            _shoot = true;
        }
    }
    if(_powerup == true){                                                       //set shoot flag to true 2 game loops (1/3 seconds) after last shot if powerup collected
        if (_old_counter + 2 <= flag_counter_) {                
            _shoot = true;
        }
    }
}
