#include "ShipBullet.h"

ShipBullet::ShipBullet()
{
}

ShipBullet::~ShipBullet()
{
}

void ShipBullet::init(int x, int y)  
{
    _speed = 2;                                                                 //speed of bullets upwards is 2 
    _hit = false;                                                               //bullet is 'alive'
    _x = x;                                                                     //sets x position to input x (middle of the ship)
    _y = y;                                                                     //sets y position to input y (top of the ship)
}

void ShipBullet::render(N5110 &lcd)
{
    if(_hit == false) {                                                         //if the bullet has not yet caused a hit, draw a pixel at x and y position
        lcd.setPixel(_x,_y,true);
    }
}

void ShipBullet::update(Gamepad &pad,N5110 &lcd) 
{
    _y-= _speed;                                                                //ship bullet ascends towards the top of the screen
}
    
Vector2D ShipBullet::get_position() 
{
    Vector2D p = {_x,_y};                                                       //returns a 2D vector of the x and y position of the bullet
    return p;    
}

void ShipBullet::set_hit(bool hit) 
{
    _hit = hit;                                                                 //used to set the hit value of a bullet that has caused a hit
}

bool ShipBullet::get_hit() 
{
    bool x = _hit;                                                              //returns the hit value of the bullet
    return x;
}
    

    
    