#include "Ship.h"


Ship::Ship()
{

}

Ship::~Ship()
{

}

void Ship::init(int height, int width)                                          
{
    _x = WIDTH/2 - width/2;                                                     //set the start x position to the middle of the screen
    _y = HEIGHT - 2;                                                            //set the y psotion to the bottom of the screen, this will not change
    _height = height;                                                           //height of the ship defined in main file and is input to init function
    _width = width;                                                             //width of the ship defined in main file and is input to the init function
    _speed = 0;                                                                 //ship starts stationary, speed set by joystick
    _life = true;                                                               //ship is set as alive until hit by alien or bullet
    _ship_bullet_vector.init();                                                 //initialising the class that creates the vector of ship bullets
}


void Ship::render(N5110 &lcd)
{ 
    _ship_bullet_vector.render(lcd);                                            //draws the vector of bullets
    
    if(_life == true){
    lcd.setPixel(_x+_width/2,_y - 1,true);                                                          //draws the ship if alive
    lcd.drawLine(_x,_y,_x+_width-1,_y,1);
    lcd.setPixel(_x,_y+1,true);
    lcd.setPixel(_x + _width - 1,_y+1,true);
    }
}

void Ship::update(Direction d, float mag, Gamepad &pad, N5110 &lcd, int counter, bool powerup)
{
    _powerup = powerup;
    _speed = int(mag*5.0f);                                                     //speed is set by offset of the joystick  

    if (d == E) {                                                               //move ship right if joystick is moved right
        _x+=_speed;                                                             //move ship by increase ing position by speed value
    } 
    else if (d == NE) {                                                         //move ship right by half speed if joysick orientation has right component
        _x+=0.5*_speed;
    } 
    else if (d == SE) {
        _x+=0.5*_speed;
    } 
    else if (d == W) {                                                          //same as above but for left
        _x-=_speed;
    } 
    else if (d == NW) {
        _x-=0.5*_speed;
    } 
    else if (d == SW) {
        _x-=0.5*_speed;
    }
    
    if (_x < 1) {                                                               //return ship to screen if ship goes off screen
        _x = 1;
    }
    if (_x > WIDTH - _width - 1) {
        _x = WIDTH - _width - 1;
    }
    
    _ship_bullet_vector.update(pad, lcd, _x+4, _y, counter, _powerup);          //update the ship bullet vector
    
    if (_life == false) {                                                       //turn on LEDs when ship dies
        pad.leds_on();
    }
}

Vector2D Ship::get_position() 
{
    Vector2D p = {_x,_y};                                                       //create 2D vector of ship x and y position
    return p;                                                                   //return the vector
}

void Ship::set_life(bool life)
{
    _life = life;                                                               //set life of the ship to input of function
}
    
bool Ship::get_life()
{
    return _life;                                                               //return the life of the ship (alive or dead)
}

vector<ShipBullet> Ship::get_bullet_vector()
{
    vector<ShipBullet> v = _ship_bullet_vector.get_vector();                    //get the vector of ship bullets
    return v;                                                                   //return the vector
}
    
void Ship::set_bullet_hit(int i, bool hit)
{
    _ship_bullet_vector.set_hit(i,hit);                                         //set the hit value of bullet with index i in the ship bullet vector 
}
    
    