#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** Rock Class
@author Joshua Ohara, el18jkeo, 201291390
@brief Creates and control the rocks which make up the cover 
@date May 2020
*/ 

class Rock
{
public: 

    /**Sets the starting value of private variables*/
    void init(int x, int y, int size);                                          //sets private variables to inputs
    
    /**Draws the rock of it is alive*/
    void render(N5110 &lcd);                                                    //draws rock
    
    
    //accessors and mutators//
    
    /*Returns a 2D vector of the position of the rock
    *@return rock position (Vector2D)
    */
    Vector2D get_position();                                                    //returns position of the rock
    
    /**Sets the life value of the rock
    *@param _life (bool)
    */
    void set_life(bool x);                                                      //sets the life variable of the rock
    
    /**Returns the life value of the rock
    *@return _life (bool)
    */
    bool get_life();                                                            //returns the life variable of the rock
    
private:
    int _x;                                                                     //x position of the rock
    int _y;                                                                     //y position of the rock
    bool _life;                                                                 //life variable
    int _size;                                                                  //size of the rock

};