#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** PowerUp class
* @brief Creates and controlsalien power up object
* @author Joshua O'hara
* @date May, 2017
*/
class PowerUp
{    
public:

    /**Constructor*/
    PowerUp();                                                              
    
    /**Destructor*/
    ~PowerUp();
    
    /**Sets starting private variables*/
    void init(int x, int y, int size);                                          //initialises objects and sets private variables
    
    /**Draws powerup if hit has not yet occured (hit = false)*/
    void render(N5110 &lcd);                                                    //draws power up 
    
    /*Updates private variables of powerup*/
    void update();                                                              //udpdates private variables
    
    //accessors and mutators
    
    /**Returns a 2D vector containing x and y position of the vector
    *@return powerup position (Vector2D)
    */
    Vector2D get_position();                                                    //returns the x and y position of the power up
    
    /**Sets the hit value of the powerup
    @param _hit (bool)
    */
    void set_hit(bool x);                                                       //sets the hit value of the power up
    
    /**Returns the hit value of the powerup
    @return _hit (bool)
    */
    bool get_hit();                                                             //returns the hit value of the power up
    
private:
    int _y;                                                                     //y position of the powerup
    int _x;                                                                     //x position of the powerup
    int _speed;                                                                 //speed of the bullet (y direction)
    int _size;                                                                  //size of the powerup (width)
    bool _hit;                                                                  //variable to show if powerup has caused a hit, functions the same as the life variable of the ship but logically opposite
    
};
    
