#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Rock.h"
#include <vector>

/** Cover Class
@author Joshua Ohara, el18jkeo, 201291390
@brief Controls and creates the cover which is a vector of rocks  
@date May 2020
*/ 

class Cover
{
public:

    /**Constructor*/
    Cover();
    
    /**Destructor*/
    ~Cover();
    
    /**Sets starting private variables and creates vector of rocks*/
    void init(int x, int y, int no_rocks);                                      //initialise cover object (vector of rocks) and set private variables
    
    /**Creates the vector of rocks*/
    void create_cover();                                                        //function to create the vector of rocks
    
    /**Iterates through vector and draws each rock*/
    void render(N5110 &lcd);                                                    //draw the rocks in the cover

    //accessors and mutators//
    
    /**Returns a copy of the vector of rocks
    *@return _alien_cover (vector<Rock>)
    */
    vector<Rock> get_vector();                                                  //return a copy of the vector of rocks
    
    /**Sets the life value of rock i in the vector of rocks
    *@param rock life (bool)
    */
    void set_life(int i, bool x);                                               //set the life of rock i in the vector
    
    /**Returns the life value of rock i in the vector of rocks
    *@return rock life (bool)
    */
    bool get_life(int i);                                                       //return the life of rock i in the vector
    
private:
    int _x;
    int _y;
    int _rock_number;
    int _row_size;
    int _spacing;
    vector<Rock> _alien_cover;
};
