#include "Armada.h"

Armada::Armada()
{
}

Armada::~Armada()
{
}

void Armada::init(int no_aliens, int alien_size, int column_size, int row_size, int level) 
{
    _x = 4;                                                                                      //start armada at (4,4)
    _y = 4;
    _step_x = alien_size + 6;                                                                   //space between top left of each alien is 10 in x and y direction
    _step_y = alien_size + 6;
    _alien_number = no_aliens;                                                                  //number of aliens in armada
    _alien_size = alien_size;                                                                   //size of alien
    _column_size = column_size;                                                                 //number of aliens in column of armada
    _row_size = row_size;                                                                       //number of aliens in row of the armada
    create_armada(level);                                                                       //create armada of aliens
}

void Armada::create_armada(int level) 
{
    for (int i = 0; i < _alien_number; i++) {                                               //create a vector of _alien_number aliens
        int remainder_x_ = i%_column_size;                                                  //find the row index of the alien (e.g. the 3rd alien in the row), like x position in vector 
        int remainder_y_ = i/_column_size;                                                  //find the column index of the alien (e.g. the 3rd alien in the column), like y position in vector 
        int init_x_ = remainder_x_*_step_x;                                                 //starting x position is the row index multiplied by the spacing between the aliens
        int init_y_ = remainder_y_*_step_y;                                                 //starting y position is the column index multiplied by the spacing between the aliens
        Alien new_alien;                                                                    //create a new alien
        new_alien.init(init_x_, init_y_, _alien_size, level);                               //initialise new alien
        _alien_fleet.push_back(new_alien);                                                   //add new alien to armada vector
    }
}
   
void Armada::render(N5110 &lcd) 
{
    for (int i =0; i < _alien_fleet.size(); i++) {
       _alien_fleet[i].render(lcd);                                                          //draw aliens in armada
    }
}

void Armada::update(Gamepad &pad, int counter, int level) 
{
    for (int i =0; i < _alien_fleet.size(); i++) {
        int _remainder_x = i%_column_size;
            _alien_fleet[i].update(_step_x, _remainder_x, pad, counter, level);                //update each alien in the armada
    }
    update_armada_life();                                                                   //update armada life variable
}
    
vector<Alien> Armada::get_vector() 
{
    vector<Alien> v = _alien_fleet;                                                          //return a copy of the alien armada vector
    return v;
}
    
void Armada::set_life(int i, bool x) 
{                          
    _alien_fleet[i].set_life(x);                                                //set the life of alien i in the vector
}

bool Armada::get_life(int i) 
{
    return _alien_fleet[i].get_life();                                          //return the life of alien i in the vector
    }

vector<AlienBullet> Armada::get_alien_bullet_vector(int i)
{
    vector<AlienBullet> v = _alien_fleet[i].get_bullet_vector();                //return the vector of bullets for alien i in the vector
    return v;
}
    
void Armada::set_bullet_hit(int n, int i, bool hit)
{
    _alien_fleet[n].set_bullet_hit(i,hit);                                      //set the hit value of bullet i in alien n's bullet vector
}

void Armada::update_armada_life()
{
    _armada_life = false;
    for(int i = 0; i < _alien_fleet.size(); i++){                               //set armada life to false and then back to true if at least one alien is alive
        if(_alien_fleet[i].get_life() == true){                                 //will return false if all aliens are dead        
            _armada_life = true;
            //printf("1");
        }
    }
}

bool Armada::get_armada_life()
{
    return _armada_life;                                                         //return the life value of armada
}

void Armada::set_alien_powerup_hit(int i, bool x)
{
    _alien_fleet[i].set_powerup_hit(x);                                         //sets hit value of alien i's powerup
}