#include "AlienBulletVector.h"

AlienBulletVector::AlienBulletVector()
{
}

AlienBulletVector::~AlienBulletVector()
{
}

void AlienBulletVector::init()                                                       //set x and y position to 0 until set by update function
{
    _x = 0;
    _y = 0;
}

void AlienBulletVector::render(N5110 &lcd) 
{
    for (int i = 0; i < _alien_bullet_vector.size(); i++) {                     //draw all bullets in the bullet vector
        _alien_bullet_vector[i].render(lcd);
    }
}

void AlienBulletVector::update(int alien_x, int alien_y, bool shoot) 
{
    _x = alien_x;                                                               //set x and y of new bullet to x and y of ship
    _y = alien_y;
    bool shoot_ = shoot;                                                        //copy shoot for use inside function
    
    if(shoot_ == true) {                                                        //if shoot flg is set, add new bullet to the vector, initilise this bullet
        AlienBullet new_bullet;
        new_bullet.init(_x,_y);
        _alien_bullet_vector.push_back(new_bullet);
        //printf("new bullet added");
    }
    
    for (int i = 0; i < _alien_bullet_vector.size(); i++) {                     //update the bullets in the vector
        _alien_bullet_vector[i].update();
    }
}

vector<AlienBullet> AlienBulletVector::get_vector() 
{
    vector<AlienBullet> v = _alien_bullet_vector;
    return v;                                                                   //return a copy of the bullet vector
}
    
void AlienBulletVector::set_hit(int i, bool x)
{
    _alien_bullet_vector[i].set_hit(x);                                         //set hit value of bullet i in the vector of bullets
}
