#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** AlienBullet class
* @brief Creates and controls alien bullet object
* @author Joshua O'hara
* @date May, 2017
*/

class AlienBullet
{    

public:

    /**Constructor*/
    AlienBullet();                                                              
    
    /**Destructor*/
    ~AlienBullet();
    
    /**Sets private variables to starting values*/
    void init(int x, int y);                                                    //initialises objects and sets private variables
    
    /**Draws the bullet if it has not yet been hit*/
    void render(N5110 &lcd);                                                    //draws bullet 
    
    /**Updates relevant private variables*/
    void update();                                                              //udpdates private variables
    
    //accessors and mutators
    
    /**Returns a 2D vector of the x and y position of the bullet
    *@return bullets position (Vector2D)
    */
    Vector2D get_position();                                                    //returns the x and y position of the bullet
    
    /**Sets the hit value of the bullet, hit = true means bullet has hit something
    *@param _hit (bool)
    */
    void set_hit(bool x);                                                       //sets the hit value of the bullet
    
    /**Returns the hit value of the bullet
    *@return _hit (bool)
    */
    bool get_hit();                                                             //returns the hit value of the bullet
    
private:
    int _y;                                                                     //y position of the bullet
    int _x;                                                                     //x position of the bullet
    int _speed;                                                                 //speed of the bullet (y direction)
    bool _hit;                                                                  //variable to show if bullet has caused a hit, functions the same as the life variable of the ship but logically opposite
};
    
    