#include "AlienBullet.h"

AlienBullet::AlienBullet()
{
}

AlienBullet::~AlienBullet()
{
}

void AlienBullet::init(int x, int y)  
{
    _speed = 1;                                                                 //bullet speed set to 1
    _hit = false;                                                               //bullet is alive and able to cause collision
    _x = x;                                                                     //x position is set as input of function (middle of alien)
    _y = y;                                                                     //y position is set as input of function (bottom of alien)
}

void AlienBullet::render(N5110 &lcd)
{
    if(_hit == false) {
        lcd.setPixel(_x,_y,true);                                               //draws a pixel black if bullet has not yet caused a hit
    }
}

void AlienBullet::update() 
{
    _y+= _speed;                                                                //y position increasing with speed (moving down screen)
}
    
Vector2D AlienBullet::get_position() 
{
    Vector2D p = {_x,_y};                                                       //returns a 2D vector of the x and y position of the bullet
    return p;    
}

void AlienBullet::set_hit(bool x) 
{
    _hit = x;                                                                   //sets the hit value of the bullet
    //print("setting hit");
}

bool AlienBullet::get_hit() 
{
    bool x = _hit;                                                              //returns the hit value of the bullet
    return x;
    //printf("gettinghit");
}
    
