#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "ShipBullet.h"
#include <vector>

/** ShipBulletVector Class
@author Joshua Ohara, el18jkeo, 201291390
@brief Controls and creates the ship bullet vector 
@date May 2020
*/ 

class ShipBulletVector
{    
public:

    /**Constructor*/
    ShipBulletVector();
    
    /**Destructor*/
    ~ShipBulletVector();
    
    /**Sets starting values for private variables*/
    void init();                                                                                //initialise shoot value to 1 and loop counter to 0
    
    /**Iterate through vector of ship bullets and draw them*/
    void render(N5110 &lcd);                                                                    //draw the vector of bullets
    
    /**Iterate through vector of ship bullets and update them,
    *set shoot flag
    *shoot if players presses button and shoot flag is true
    */
    void update(Gamepad &pad, N5110 &lcd, int ship_x, int ship_y, int counter, bool powerup);   //update private variables, bullet vector, shoot etc


    //accessors and mutators//

    /**Returns copy of vector of ship bullets
    *@return _bullet_vector (vector<ShipBullet>)
    */
    vector<ShipBullet> get_vector();                                                            //returns a copy of the vector of ship bullets for collision check
    
    /**Set hit value of bullet i in the vector of bullets
    *@param hit (bool)
    */
    void set_hit(int i, bool x);                                                                //sets the hit value of ship bullet i in the vector
    
    /**Sets the shoot flag to true if it has been x amount of time since last shot,
    *time x is reduced if player collects a powerup
    *@param _shoot (bool)
    */
    void flag_set(int counter);                                                                 //sets the shoot flag (if shoot = true player can shoot)

private:
    vector<ShipBullet> _bullet_vector;                                                          //vector of ship bullets
    int _x;                                                                                     //x position of the ship 
    int _y;                                                                                     //y position of the ship
    bool _shoot;                                                                                //shoot flag (if true player can shoot)
    int _old_counter;                                                                           //old counter for checking time since last shot
    bool _powerup;                                                                              //bool to show if player has collected a powerup this level
};