#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** ShipBullet Class
@author Joshua Ohara, el18jkeo, 201291390
@brief Controls the ship bullets
@date May 2020
*/ 

class ShipBullet

{    
public:

    /**Constructor*/
    ShipBullet(); 
    
    /**Destructor*/
    ~ShipBullet();
    
    /*Set starting value of private variables*/
    void init(int x, int y);                                                    //initialises object and sets private variables, starting x and y the same as the ship
    
    /**Draws the bullet if hit has not occured*/
    void render(N5110 &lcd);                                                    //draws the bullet at current x and y
    
    /**Updates the private variables of the bullet*/
    void update(Gamepad &pad,N5110 &lcd);                                       //updates private variables of the ship
    
    //accessors and mutators
    
    /**Returns a 2D vector of the position of the bullet
    *@return bullet position (Vector2D)
    */
    Vector2D get_position();                                                    //returns the position of the bullet for collision check
    
    /**Set hit value of the bullet
    *@param _hit (bool)
    */
    void set_hit(bool hit);                                                     //sets the 'hit' value of the bullet (if hit is true, bullet has collided and is no longer drawn, the same function as the 'life' variable for the ship but logically opposite)
    
    /**Returns the hit value of the bullet
    *@return _hit (bool)
    */
    bool get_hit();                                                             //returns the hit value of the bullet
    
private:

    int _y;                                                                     //y position of the bullet
    int _x;                                                                     //x position of the bullet
    int _speed;                                                                 //speed of the bullet (y direction)                                                               
    bool _hit;                                                                  //hit value of the bullet
};
    
    
    
    