#ifndef SHIP_H
#define SHIP_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "ShipBulletVector.h"

/** Ship Class
@author Joshua Ohara, el18jkeo, 201291390
@brief Controls the ship  
@date May 2020
*/ 

class Ship
{
    
public: 
    
    /** Constructor */
    Ship();
    
    /** Destructor */
    ~Ship();
    
    /** Initialise private member variables to starting values*/
    void init(int height, int width);                                                               //initialises ship object, sets private variables
    
    /**Draws ship object at current x and y position*/
    void render(N5110 &lcd);                                                                        //draws ship if alive
    
    /**Update the position and shoot flag of the ship based on joystick position*/
    void update(Direction d, float mag, Gamepad &pad, N5110 &lcd, int counter, bool powerup);       //updates the position and shooting of the ship      

    /**Sets the life value of the ship object, true is alive false is dead
    *@param the life value (bool)  
    */
    void set_life(bool life);                                                                       //sets the life of the ship
    
    /**Returns the value of the life to check for collisions
    *@return life value (bool)
    */
    bool get_life();                                                                                //returns the life of the ship
    
    /**Sets the hit value of bullet i in this ship's vector of bullets, true is hit has occurred, false it has not
    *@param bullet hit (bool)
    */
    void set_bullet_hit(int i, bool hit);                                                           //sets the life of a given ship bullet (hit if a collsion occurs)
    
    /**Returns a 2D vector containing the x and y position of the ship
    *@return ship position (Vector2D)
    */
    Vector2D get_position();                                                                        //returns the position of the ship for collision check
    
    /**Returns a copy of this ship's vector of ship bullets
    *@return ship's bullet vector (vector<ShipBullet>)
    */
    vector<ShipBullet> get_bullet_vector();                                                         //returns the ship bullet vector for collsion check
    
private:
    int _height;                                                                                    //height of the ship main rectangle
    int _width;                                                                                     //width of the ship main rectangle
    int _x;                                                                                         //x posittion of ship
    int _y;                                                                                         //y position of the ship
    int _speed;                                                                                     //speed of the ship in x direction
    bool _powerup;                                                                                  //powerup flag of ship
    bool _life;                                                                                     //whether the ship is alive or not
    ShipBulletVector _ship_bullet_vector;                                                           //object to create ship bullet vector
};

#endif