#include "PowerUp.h"

PowerUp::PowerUp()
{
}

PowerUp::~PowerUp()
{
}

void PowerUp::init(int x, int y, int size)  
{
    _speed = 1;                                                                 //powerup speed set to 1
    _hit = false;                                                               //powerup is alive and able to cause collision
    _x = x;                                                                     //x position is set as input of function (x position of dead alien)
    _y = y;                                                                     //y position is set as input of function (y position of dead alien) 
    _size = size;                                                               //size (width) of powerup is set to input
}

void PowerUp::render(N5110 &lcd)
{
    if(_hit == false) {
        lcd.drawRect(_x, _y, _size, _size - 1, FILL_BLACK);                     //draws a rectangle size * size-1 if no hit has occured
    }
}

void PowerUp::update() 
{
    _y+= _speed;                                                                //y position increasing with speed (moving down screen)
}
    
Vector2D PowerUp::get_position() 
{
    Vector2D p = {_x,_y};                                                       //returns a 2D vector of the x and y position of the powerup
    return p;    
}

void PowerUp::set_hit(bool x) 
{
    _hit = x;                                                                   //sets the hit value of the powerup
}

bool PowerUp::get_hit() 
{
    bool x = _hit;                                                              //returns the hit value of the powerup
    return x;
}