#include "Cover.h"

Cover::Cover()
{
}

Cover::~Cover()
{
}

void Cover::init(int x, int y, int no_rocks)
{
    _x = x;                                                                     //set x and y position
    _y = y;
    _rock_number = no_rocks;                                                    //set number of rocks in the cover                                        
    _spacing = 3;                                                               //set the spacing between rocks
    _row_size = 5;                                                              //set the number of rocks in each row of the cover
    create_cover();                                                             //create the vector of rocks
}

void Cover::create_cover() 
{
    for (int i = 0; i < _rock_number; i++) {                                    //add _rock_number of rocks to vector
        int remainder_x_ = i%_row_size;                                         //find the row index of the rock (e.g. the 3rd rock in the row), like x position in vector    
        int remainder_y_ = i/_row_size;                                         //find the column index of the rock (e.g. the 2nd rock in the column), like y position in vector
        int init_x_ = remainder_x_*_spacing + _x;                               //set the x position of new rock based on spacing between rocks and the new rocks position in the cover
        int init_y_ = remainder_y_*_spacing + _y;                               //set the y position of new rock based on spacing between rocks and the new rocks position in the cover
        Rock new_rock;                                                          //create new rock
        new_rock.init(init_x_, init_y_, _spacing);                              //initialise new rock, spacing is equal to size as the rocks are all touching
        _alien_cover.push_back(new_rock);                                        //add new rock to vector
        
    }
}
   
void Cover::render(N5110 &lcd) 
{
    for (int i = 0; i < _alien_cover.size(); i++) {
       _alien_cover[i].render(lcd);                                              //draw all rocks in the cover vector
    }
}

vector<Rock> Cover::get_vector() 
{
    vector<Rock> v = _alien_cover;
    return v;                                                                   //return a copy of the vector of rocks
}
    
void Cover::set_life(int i, bool x) 
{
    _alien_cover[i].set_life(x);                                                //set the life variable of rock i in the cover
}

bool Cover::get_life(int i)
{
    return _alien_cover[i].get_life();                                          //return the life value of rock i in the cover
}