#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Alien.h"
#include <vector>

/** Armada Class
@author Joshua Ohara, el18jkeo, 201291390
@brief Creates and controls the vector of aliens (i.e. the armada) 
@date May 2020
*/ 

class Armada
{
    
public:

    /**Constructor*/
    Armada();
    
    /**Destructor*/
    ~Armada();
    
    /**Sets the private variables of the armada, based on inputs from engine*/
    void init(int no_aliens, int alien_size, int column_size, int row_size, int level);     //set private variables to function inputs and create vector of aliens
    
    /**Create a vector of aliens and initialise these aliens*/
    void create_armada(int level);                                                          //create vector of aliens
    
    /**Iterate through armada and draw aliens in the armada*/
    void render(N5110 &lcd);                                                                //draw vector of aliens
    
    /**Update the aliens in the armada*/
    void update(Gamepad &pad, int counter, int level);                                      //update vector of aliens
    
    //accessors and mutators//
    
    /**Sets the armada life value to true if at least 1 alien is alive and to 
    *false if no aliens are left alive
    *@param _armada_life (bool)
    */
    void update_armada_life();                                                              //update armada life variable
    
    /**Returns vector of aliens
    @return _alien_fleet
    */
    vector<Alien> get_vector();                                                             //return copy of vector of aliens
    
    /**Set life value of alien i in vector
    *@param alien life (bool)
    */
    void set_life(int i, bool x);                                                           //set life variable of alien i in vector
    
    /**Returns copy of the alien bullet vector of alien i
    *@return alien bullet vector (vector<AlienBullet>)
    */
    vector<AlienBullet> get_alien_bullet_vector(int i);                                     //return bullet vector of alien i in the armada
    
    /**Sets hit value of bullet i in alien n's vector of alien bullets
    *@param alien bullet hit (bool)
    */
    void set_bullet_hit(int n, int i, bool hit);                                            //set bullet hit variable of bullet i in alien n's bullet vector
    
    /**Returns the life value of alien i in the vector
    *@return life (bool)
    */
    bool get_life(int i);                                                                   //return the life of alien i 
    
    /**Returns the life value of the whole armada
    *@return _armada_life (bool)
    */
    bool get_armada_life();                                                                 //return the life variable of the entire armada
    
    /**Sets the hit value of the powerup of alien i in te vector
    @param powerup hit of alien i (bool)
    */
    void set_alien_powerup_hit(int i, bool x);                                              //sets the hit value of the powerup belonging to alien i in the vector of aliens
    
private:
    int _x;                                                                                 //x position of armada (top left)
    int _y;                                                                                 //y position of armada (top left)
    int _step_x;                                                                            //horizontal spacing between aliens
    int _step_y;                                                                            //vertical spacing between aliens
    int _alien_number;                                                                      //number of aliens in armada
    int _column_size;                                                                       //size of the columns of aliens in armada
    int _row_size;                                                                          //size of the rows of aliens in the armada
    int _alien_size;                                                                        //size of the alien
    vector<Alien> _alien_fleet;                                                             //vector of aliens
    bool _armada_life;                                                                      //armada life variable
};

