
#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "AlienBullet.h"
#include <vector>
#include <Timeout.h>

/** AlienBulletVector Class
@author Joshua Ohara, el18jkeo, 201291390
@brief Controls alien bullets
@date May 2020
*/ 

class AlienBulletVector
{    

public:

    /**Constructor*/
    AlienBulletVector();

    /**Destructor*/
    ~AlienBulletVector();
    
    /**Set private variables to initial value*/
    void init();                                                                //set private variables                                                           
    
    /**Iterates through vector and draws each bullet in bullet vector*/
    void render(N5110 &lcd);                                                    //draw the vector of alien bullets
   
    /**Updates the private variables of the bullets in the vector*/
    void update(int alien_x, int alien_y, bool shoot);                          //update private variables, bullet vector

    //accessorts mutators
    
    /**Returns a copy of the vector of alien bullets
    *@return _alien_bullet_vector (vector<AlienBullet>)
    */
    vector<AlienBullet> get_vector();                                           //return copy of this alien's bullet vector
    
    /**Sets the hit value of bullet i in the vector
    *@param hit (bool)
    */
    void set_hit(int i, bool x);                                                //set the hit value of bullet i in the vector 

private:
    vector<AlienBullet> _alien_bullet_vector;                                   //create vector of alien bullets
    int _x;                                                                     //alien x position for creation of new bullets
    int _y;                                                                     //alien y position for creation of new bullets
};