#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "AlienBulletVector.h"
#include "PowerUp.h"
#include <vector>

/** Alien Class
@author Joshua Ohara, el18jkeo, 201291390
@brief Controls the aliens  
@date May 2020
*/ 

class Alien
{
public: 

    /**Initialise private variables to starting values*/
    void init(int x, int y, int size, int level);                                       //initialise alien object and set private variables
    
    /**Draw alien object if alive at current x and y position*/
    void render(N5110 &lcd);                                                            //draw aliens
    
    /**Update private variables and flags*/
    void update(int step_x, int remainder_x, Gamepad &pad, int counter, int level);     //update private variables (position, shoot value)
    
    /**Chance to set shoot flag on everage every 8 game loop iterations
    *by creating a random number and testing if it is within  certain limit,
    *if it does, shoot flag is set and alien will shoot, limit becomes broader
    *as level increases so that aliens will shoot more
    *@param _shoot (bool)
    */
    void shoot_flag_set(int counter, int level);                                        //set the shoot flag
    
    //Accessors and Mutators
    
    /**Sets the alien's life value
    *@param _life (bool)
    */
    void set_life(bool x);                                                              //set the aliens life
    
    /**Returns the alien's life value
    *@return _life (bool)
    */
    bool get_life();                                                                    //returns the alien life
    
    /**Returns a 2D vector of alien's x and y position
    *@return position (Vector2D)
    */
    Vector2D get_position();                                                            //returns 2D vector of alien x and y position
    
    /**Returns the alien's vector of alien bullets
    *@return _alien_bullet_vector (vector<AlienBullet>)
    */
    vector<AlienBullet> get_bullet_vector();                                            //returns a copy of this aliens bullet vector
    
    /**Sets the hit value of bullet i in the alien's vector of alien bullets
    *@param bullet hit (bool)
    */
    void set_bullet_hit(int i, bool hit);                                               //sets the hit value of bullet i in this aliens vector of bullets
    
    /**Sets the value of the power flag and the create powerup flag if alien is
    *not alive, create powerup flag can only be set once when alien dies as 
    *powerup flag is set to false
    *@param _powerup (bool)
    *@param _create_powerup (bool)
    */
    void create_powerup_flag_set();                                                    //sets powerup flag that allows powerup to be created
    
    /**Returns the hit value of a powerup that has been deployed
    *@return powerup hit (bool)
    */
    bool get_powerup_hit();                                                     //returns powerup hit value if created
    
    /**Sets the value of the powerup hit value
    *@param powerup hit (bool)
    */
    void set_powerup_hit(bool x);                                               //sets the hit value of powerup if created
    
    /**Returns a 2D vector containing the powerup x and y position
    *@return powerup position (Vector2D)
    */
    Vector2D get_powerup_position();                                            //returns 2D vector of powerups position if created
    
private:
    int _x;                                                                             //x position of the alien
    int _y;                                                                             //y position of the alien
    bool _alive;                                                                        //bool value of if alien is alive
    int _speed;                                                                         //alien speed in x direction
    float _size;                                                                        //alien size
    bool _shoot;                                                                        //shoot flag (if shoot is true alien can shoot)
    bool _powerup;                                                                      //powerup flag (allows powerup to be shot)
    bool _create_powerup;                                                               //flag to show both that a powerup should be created and that a powerup has been created 
    AlienBulletVector _alien_bullet_vector;                                             //alien's vector of bullets
    vector<PowerUp> _powerup_vector;                                                    //aliens vector of powerups, making powerup accessible to rest of class
};
