#include "Alien.h"

 
void Alien::init(int x, int y, int size, int level) {
    _alive = true;                                                              //alien life is true  
    _shoot = false;                                                             //set shoot flag to false to be turned true by flag set function
    _powerup = true;                                                            //set powerup flag to true, will be turned to false when alien dies so alien can only drop 1 powerup
    _create_powerup = false;                                                    //create powerup flag false as no powerup has been created
    _x = x;                                                                     //set starting position
    _y = y;                                                                   
    _size = size;                                                               //set size (width)
    _speed = 1 + 0.3 * level;                                                   //set speed in x diretion, increases with level to make game get harder
    _alien_bullet_vector.init();                                                //initialise the alien's vector of bullets
//    printf(" speed = %2d ",Speed);
    
}

void Alien::render(N5110 &lcd) 
{
    if(_alive == true){             
        lcd.drawLine(_x,_y+1,_x+_size-1,_y+1,1);                                //draw alien (traingular pointing down)
        lcd.setPixel(_x,_y,true);
        lcd.setPixel(_x+_size-1,_y,true);
        lcd.setPixel(_x+_size/2,_y+2,true);
        _alien_bullet_vector.render(lcd);
    } 
    if(_create_powerup == true){                                                //draw powerup if one has been created
        _powerup_vector[0].render(lcd);                                         //we only need to check 0th powerup in vector as only one can be added to vector per alien
    //printf("powerup render");   
    }
}

Vector2D Alien::get_position() 
{
    Vector2D p = {_x,_y};                                                       //returns a 2d vector of the alien's position
    return p;
}

void Alien::update(int step_x, int remainder_x, Gamepad &pad, int counter, int level) 
{
    _x+=_speed;                                                                 //change xposition according to speed
    int counter_ = counter;                                                     //copy counter value to function variable
    int step_x_ = step_x;                                                       //copy step value to function variable
    int remainder_x_ = remainder_x;                                             //copy remainder value to function variable
    if (_x < 1 + remainder_x_*step_x_) {                                        //make alien change directions and move down screen if alien armada reaches edge of the screen
        _x = 1 + remainder_x_*step_x_;                                          //using the remainder_x_ value (which shows this alien's position in the row, e.g 3 from left)
        _speed = -_speed;                                                       //and the distance between alien's, we can calculate at which point on the screen each alien
        _y = _y + 2;                                                            //should change directions
    }
    if (_x > WIDTH - _size - 1 - (4-remainder_x_)*step_x_) {                    //same process but for other side of screen
        _x = WIDTH - _size - 1 - (4-remainder_x_)*step_x_;
        _speed = -_speed;
        _y = _y + 2;
    }
    shoot_flag_set(counter_,level);                                             //runs flag set function
    _alien_bullet_vector.update(_x,_y,_shoot);                                  //updates the vector of alien bullets
    _shoot = false;                                                             //sets shoot flag to false in case alien shot on this loop
    
    if(_powerup == true){                                                       //runs the powerup flag set to determine if the create powerup flag will be set to true upon alien death
        create_powerup_flag_set();                                              //powerup flag set function will not run if alien is still alive so create powerup flag cannot be set to true
        if(_create_powerup == true){                                            //powerup flag will be set to false after alien dies so this block of code is only run 1 time after death
            PowerUp new_powerup_;                                               //creating a new powerup only oncre
            new_powerup_.init(_x,_y,3);                                         //initialising powerup
            _powerup_vector.push_back(new_powerup_);                            //adding powerup to a vector for use outside of function
            //printf(" powerup created "); 
            
        }
    }
    if(_create_powerup == true){                                                //updates powerup if one has been created
        _powerup_vector[0].update();                                            //we only need to check 0th powerup in vector as only one can be added to vector per alien
        //printf("powerup update");
    }
    //printf(" speed = %2d ",Speed);
}

void Alien::set_life(bool x)
{
    _alive = x;                                                                 //sets the life of the alien
}

bool Alien::get_life()
{
    //printf("A = %2d ",Alive);
    return _alive;                                                              //returns the life of the alien
}

void Alien::shoot_flag_set(int counter, int level)
{
    int counter_ = counter;
    if(counter_%8 == 1){                                                        //sets shoot to true every 8 main loop iterations (1 1/3 secs) and if a random number falls below a decided limit and the alien is alive
        int r_ = rand()%20;                                                     //test a random number so alien doesnt shoot every 8 loops
        if((r_ < level+1)&&                                                     //limit increases with level, so aliens will shoot more as game goes on
        (_alive == true)) {
        _shoot = true;
        }
    }
}

vector<AlienBullet> Alien::get_bullet_vector()
{
    vector<AlienBullet> v = _alien_bullet_vector.get_vector();
    return v;                                                                   //return the vector of alien bullets
}
    
void Alien::set_bullet_hit(int i, bool hit)
{
    _alien_bullet_vector.set_hit(i,hit);                                        //sets the hit value of bullet i in this aliens bullet vector
}

void Alien::create_powerup_flag_set()
{
    if(_alive == false){                                                        //check to see if ship has died
        _powerup = false;                                                       //set powerup flag to false as we only want to create 1 powerup per alien when alien dies
        int rand_ = rand()%6;                                                   //test a random number to set create powerup flag, as we dont want every alien death to yield a powerup drop
        if(rand_ == 0){
            _create_powerup = true;
        }
    }
}

Vector2D Alien::get_powerup_position()
{
    Vector2D v;
    if(_create_powerup == true){                                                //returns powerup position if powerup has been created
        v = _powerup_vector[0].get_position();                                  //we only need to check 0th powerup in vector as only one can be added to vector per alien
    }
    return v;
}

void Alien::set_powerup_hit(bool x)
{
    if(_create_powerup == true){                                                //sets powerup hit if powerup has been created
        _powerup_vector[0].set_hit(x);                                          //we only need to check 0th powerup in vector as only one can be added to vector per alien
    }
}

bool Alien::get_powerup_hit()
{
    bool x;
    if(_create_powerup == true){                                                //returns powerup hit value if powerup has been created
        x = _powerup_vector[0].get_hit();                                       //we only need to check 0th powerup in vector as only one can be added to vector per alien
    }
    return x;
}
    