#ifndef TESTS_H
#define TESTS_H

#include "Spikes_test.h"
#include "Aim_test.h"
#include "Eng_test.h"
#include "Pup_test.h"
#include "Heston_test.h"
#include "Highscore_test.h"
#include "Menu_test.h"
#include "SDFileSystem.h"

/**
 * @brief Run all the tests for this program
 *
 * @returns The number of tests that failed
 */
 

int run_all_tests(SDFileSystem &sd)
{
    int n_tests_failed = 0; // A log of the number of tests that have failed
    
    // Run the aim initialisation test
    printf("Testing Aim_test_initialise ...\n");
    bool test_passed1 = Aim_test_initial();

    // Print out the result of this test
    if (test_passed1) {
        printf("...Passed!\n");
    }
    else {
        printf("...FAILED!\n");
        ++n_tests_failed; // Increment number of failures
    }
    
    // Run the Heston initialisation test
    printf("Testing Heston_test_initialise ...\n");
    bool test_passed2 = Heston_test_initial();

    // Print out the result of this test
    if (test_passed2) {
        printf("...Passed!\n");
    }
    else {
        printf("...FAILED!\n");
        ++n_tests_failed; // Increment number of failures
    }
    
    // Run the Heston collison test
    printf("Testing collision_heston_test ...\n");
    bool test_passed3 = collision_hest_test();

    // Print out the result of this test
    if (test_passed3) {
        printf("...Passed!\n");
    }
    else {
        printf("...FAILED!\n");
        ++n_tests_failed; // Increment number of failures
    }
    
    // Run the spike collison test
    printf("Testing collision_spike_test ...\n");
    bool test_passed4 = collision_spike_test();

    // Print out the result of this test
    if (test_passed4) {
        printf("...Passed!\n");
    }
    else {
        printf("...FAILED!\n");
        ++n_tests_failed; // Increment number of failures
    }
    
    // Run the power up collison test
    printf("Testing collision_pup_test ...\n");
    bool test_passed5 = collision_pup_test();

    // Print out the result of this test
    if (test_passed5) {
        printf("...Passed!\n");
    }
    else {
        printf("...FAILED!\n");
        ++n_tests_failed; // Increment number of failures
    }
    
    //sd card protection
    int protect = hs.geths(sd);
    
    // Run highscore test
    printf("Testing highscore_test ...\n");
    bool test_passed6 = highscore_test(sd);

    // Print out the result of this test
    if (test_passed6) {
        printf("...Passed!\n");
    }
    else {
        printf("...FAILED!\n");
        ++n_tests_failed; // Increment number of failures
    }
    
    hs.seths(sd, protect);//rewrites highscore that was on card if ran with tests
    
    // Run menu test
    printf("Testing menu_test ...\n");
    bool test_passed7 = menu_test();

    // Print out the result of this test
    if (test_passed7) {
        printf("...Passed!\n");
    }
    else {
        printf("...FAILED!\n");
        ++n_tests_failed; // Increment number of failures
    }
    
    // Run power up positioning test
    printf("Testing pup_test_double ...\n");
    bool test_passed8 = pup_test_double();

    // Print out the result of this test
    if (test_passed8) {
        printf("...Passed!\n");
    }
    else {
        printf("...FAILED!\n");
        ++n_tests_failed; // Increment number of failures
    }
    
    // Run spike updating y test
    printf("Testing spikes update y ...\n");
    bool test_passed9 = spikes_test_updatey();

    // Print out the result of this test
    if (test_passed9) {
        printf("...Passed!\n");
    }
    else {
        printf("...FAILED!\n");
        ++n_tests_failed; // Increment number of failures
    }
    
    // Run spike updating x test
    printf("Testing spikes update x ...\n");
    bool test_passed10 = spikes_test_updatex();

    // Print out the result of this test
    if (test_passed10) {
        printf("...Passed!\n");
    }
    else {
        printf("...FAILED!\n");
        ++n_tests_failed; // Increment number of failures
    }
    
    // Run spike updating x negativly test
    printf("Testing spike update negative x...\n");
    bool test_passed11 = spikes_test_updatexn();

    // Print out the result of this test
    if (test_passed11) {
        printf("...Passed!\n");
    }
    else {
        printf("...FAILED!\n");
        ++n_tests_failed; // Increment number of failures
    }
    // Repeat the above for each testing function...
    // ...
    // ...

    // Finish by printing a summary of the tests
    if (n_tests_failed > 0) {
        printf("%d tests FAILED!\n", n_tests_failed);
    }
    else {
        printf("All tests passed!\n");
    }

    return n_tests_failed;
}

#endif