#ifndef MENU_H
#define MENU_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Highscore.h"


/** Menu class
 * @brief small main menu with instructions and highscore screen
 * @author Joe Body, University of Leeds
 * @date May 2020
 */   

class Menu
{

public:

    /** Constructor */
    Menu();
    
    /** Destructor */
    ~Menu();
    
    /** Initalises Menu*/
    void init();
    
    /** displays the main menu
    * @param lcd @details N5110 object
    * @param pad @details Gamepad object
    */
    void display(N5110 &lcd, Gamepad &pad);
    
    /** Draws the spike
    * @param lcd @details N5110 object
    */
    void draw(N5110 &lcd);
    
    /** updates the option
    * @param pad @details Gamepad object
    */
    void update(Gamepad &pad);
    
    /** displays the instruction screen
    * @param lcd @details N5110 object
    * @param pad @details Gamepad object
    */
    void instructions(N5110 &lcd, Gamepad &pad);
    
    /** displays the highscore screen
    * @param lcd @details N5110 object
    * @param pad @details Gamepad object
    * @param hs @details highscore class
    * @param sd @details SD File System
    */
    void highs_screen(N5110 &lcd, Gamepad &pad, Highscore &hs, SDFileSystem &sd);
    
    /** gets the option */
    int getmode();
    
private:

    /** option corresponding to play, highscore or instruction*/
    int option;
    
    /** x position of sprite
    * @return _x
    */
    int _x;
    
    /** y position of sprite
    * @return _y
    */
    int _y;

};


#endif