#include "Menu.h"

const int curs [5][5] = 
{
    {0,0,1,0,0},
    {0,0,1,0,0},
    {1,1,0,1,1},
    {0,0,1,0,0},
    {0,0,1,0,0},
};

Menu::Menu()
{

}

Menu::~Menu()
{

}

void Menu::init()
{
    option = 1;
    _x = 1;
    _y = 17;//hovers by play to begin with
}

void Menu::display(N5110 &lcd, Gamepad &pad) //main menu display
{
    
    while ( pad.A_held() == false) {
        lcd.clear();
        lcd.setContrast( pad.read_pot1());
            
        lcd.printString("   Main Menu  ",0,0);  
        lcd.printString("     Play     ",0,2);
        lcd.printString("   Highscore  ",0,3);
        lcd.printString(" Instructions ",0,4);
        
        update(pad);
        draw(lcd);
        lcd.refresh();
        
    }
    wait(0.2);
    //return option;
}

void Menu::draw(N5110 &lcd)
{
    lcd.drawSprite(_x,_y,5,5,(int*)curs); // draw a cursor for visual sellection of mode
}

void Menu::update(Gamepad &pad)
{
    
    Direction d = pad.get_direction();
 
    if (d == S) {
        option += 1;
    } else if (d == SE) {
        option += 1;
    } else if (d == SW) {// any general south 
        option += 1;
    } else if (d == N) {
        option -= 1;
    } else if (d == NE) {
        option -= 1;
    } else if (d == NW) {//any general north
        option -= 1;
    } else {
        option = option;
    }
    
    if (option == 4){
        option = 3;
    }
    
    if (option == 0){//despite being a 'mode' this means an option is always chosen
        option = 1;
    }
    
    if (option == 1){//inline with play
        _y = 17;
    }
    
    if (option == 2){//highscore with play
        _y = 25;
    }
    
    if (option == 3){//instructions with play
        _y = 33;
    }
    
    wait(0.2);
    //printf("option =  %d\n", option);
}

void Menu::instructions(N5110 &lcd, Gamepad &pad)
{
    while ( pad.B_held() == false) {//b held works better than pressed
        lcd.clear();
            
        lcd.printString(" Instructions ",0,0);  
        lcd.printString("(move cursor  ",0,2);
        lcd.printString("with Joy-Stick",0,3);
        lcd.printString(" shoot with A)",0,4);
        lcd.printString("return press B",0,5);
            
        lcd.refresh();
        }
    wait(0.1);
}

int Menu::getmode()
{
    return option;
}

void Menu::highs_screen(N5110 &lcd, Gamepad &pad, Highscore &hs, SDFileSystem &sd)
{

    while ( pad.B_held() == false) {//b held works better than pressed
        lcd.clear();
        
        int value = hs.geths(sd);
        //printf("value %d \n", value);    
        lcd.printString("   Highscore  ",0,0);
        
        char buffer1[14];
        sprintf(buffer1,"%2d",value);//prints the stored score
        lcd.printString(buffer1,34,3);  

        lcd.printString("return press B",0,5);
            
        lcd.refresh();
        }
    wait(0.1);
}
