/* 
ELEC2645 Embedded Systems Project
School of Electronic & Electrical Engineering
University of Leeds
2019/20

Name:Joe Body
Username:el18jgb
Student ID Number:201215898
Date:11/03/2020
*/

// includes
#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "Aim.h"
#include "Heston.h"
#include "Eng.h"
#include "Menu.h"
#include "FXOS8700CQ.h"
#include "SDFileSystem.h"
#include "Highscore.h"
#include "Sound.h"


// macro for testing, includes tests.h which contains all tests
#ifdef TEST_GAME
    #include "test.h"
#endif


// objects
Gamepad pad;
N5110 lcd;
Menu menu;
Eng eng;
FXOS8700CQ acc(I2C_SDA,I2C_SCL);
Highscore hs;
SDFileSystem sd(PTE3, PTE1, PTE2, PTE4, "sd");


void init();
void render();
void play(Gamepad &pad, N5110 &lcd, FXOS8700CQ &acc);


int main()
{
    
#ifdef TEST_GAME
    int failed = run_all_tests(sd);
    printf("\n\n%d failed\n", failed);
    printf("complete \n");
#endif

    //int fps = 10;  // frames per second
    //int A_timer = 0;
    init();     // initialise and then display welcome screen...
    while (1) {
        menu.display(lcd, pad);
        int mode = menu.getmode();
        wait(0.1);  // and wait for one frame period
        if (mode == 0){
            menu.display(lcd, pad);
        }
        if (mode == 1){
            play(pad, lcd, acc);
        }
        else if (mode == 2){
            menu.highs_screen(lcd, pad, hs, sd);
        }
        else if (mode == 3){
            menu.instructions(lcd, pad);
        }
        mode = 0;
    }
    
}

// initialies all classes and libraries
void init()
{
    // need to initialise LCD and Gamepad 
    lcd.init();
    pad.init();
    
    acc.init();

    eng.init();
    

}

// this function draws each frame on the LCD
void render()
{
    // clear screen, re-draw and refresh
    lcd.clear(); 

    eng.draw(lcd);
    lcd.refresh();
}


void play(Gamepad &pad, N5110 &lcd, FXOS8700CQ &acc)
{
    int A_timer = 0;
    eng.init();
    while (1) {
        //read_input(pad);
        int fire = 0;
        if (A_timer <= 0){//shot timer to prevent spam
            fire = 0;
            if (pad.A_held()){//a held worked better than pressed
                fire = 1;
                A_timer = 6;
                
            }
        }
        

        eng.update(pad, fire, lcd, acc);
        render();
        wait(0.1);
        
        //if (fire == 1){
        int x = eng.checkgame(lcd);
            if (x == 1) {
                eng.gameover(lcd, pad, hs, sd);
                break;
            }
        //}
        
        A_timer--;
        
        eng.tik();
        //printf("fire =  %d\n", fire);
        //printf("shot cooldown =  %d\n", A_timer);

    }
}
