#ifndef HIGHSCORE_TEST_H
#define HIGHSCORE_TEST_H
 
/** highscore Test
 * @brief Checks that the written highscore gets read
 * @author Jospeh Body, University of Leeds
 * @date May 2020
 * @return true if test are passed 
 */
 
 
 bool highscore_test(SDFileSystem &sd)
{

    Highscore hs;
    
    // set the highscore
    hs.seths(sd, 10);

    // Now check that both the position is as expected
    bool success_flag = false;
    
    // Now read highscore
    int score = hs.geths(sd);
    
    // Fail the test if dont match
    if (score == 10 ) {
        success_flag = true;
    }

    return success_flag;
}

 
#endif