#ifndef HIGHSCORE_H
#define HIGHSCORE_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "SDFileSystem.h"

/** highscore Class
 * @brief reads and writes highscore
 * @author Joe Body, University of Leeds
 * @date May 2020
*/ 

class Highscore
{

public:
    
    /** Constructor */
    Highscore();
    
    /** Destructor */
    ~Highscore(); 
    
// Accessors and mutators

    /** Gets the current highscore
    * @param sd @details SD card object
    * @return current_menu_part_
    */
    int geths(SDFileSystem &sd);
    
    /** Set a new Highscore
    * @param sd @details SD card object
    * @param integer x @details new high score
    */
    void seths(SDFileSystem &sd, int x);
    
private:

    /** value stored in the sd card */
    int stored;

};

#endif
