#ifndef SPIKES_TEST_H
#define SPIKES_TEST_H
 
/** ENG Test
 * @brief Checks that the calulate_map_movement caluclates correct map_movement
 * @author Jospeh Body, University of Leeds
 * @date May 2020
 * @return true if test are passed 
 */
 
bool spikes_test_updatey()
{
    // Initialise
    Spikes spikes;
    spikes.position(2); 
    
    // Read the position
    Vector2D read_pos = spikes.get_pos();
    printf("%f, %f\n", read_pos.x, read_pos.y);

    // Now check that both the position is as expected
    bool success_flag = false;
    
    //update position
    spikes.updatey();
    
    // Read the position
    Vector2D read_pos_1 = spikes.get_pos();
    printf("%f, %f\n", read_pos_1.x, read_pos_1.y);
    
    // Fail the test if the initial position is wrong
    if (read_pos_1.x == read_pos.x || read_pos_1.y == read_pos.y +3 ) {
        success_flag = true;
    }

    return success_flag;
}

bool spikes_test_updatex()
{
    // Initialise
    Spikes spikes;
    spikes.position(4); 
    
    // Read the position
    Vector2D read_pos = spikes.get_pos();
    printf("%f, %f\n", read_pos.x, read_pos.y);

    // Now check that both the position is as expected
    bool success_flag = false;
    
    //update position
    spikes.updatex();
    
    // Read the position
    Vector2D read_pos_1 = spikes.get_pos();
    printf("%f, %f\n", read_pos_1.x, read_pos_1.y);
    
    // Fail the test if the initial position is wrong
    if (read_pos_1.x == read_pos.x + 3 || read_pos_1.y == read_pos.y ) {
        success_flag = true;
    }

    return success_flag;
}

bool spikes_test_updatexn()
{
    // Initialise
    Spikes spikes;
    spikes.position(3); 
    
    // Read the position
    Vector2D read_pos = spikes.get_pos();
    printf("%f, %f\n", read_pos.x, read_pos.y);

    // Now check that both the position is as expected
    bool success_flag = false;
    
    //update position
    spikes.updatexn();
    
    // Read the position
    Vector2D read_pos_1 = spikes.get_pos();
    printf("%f, %f\n", read_pos_1.x, read_pos_1.y);
    
    // Fail the test if the initial position is wrong
    if (read_pos_1.x == read_pos.x - 3 || read_pos_1.y == read_pos.y ) {
        success_flag = true;
    }

    return success_flag;
}
#endif