#ifndef SPIKES_H
#define SPIKES_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Aim.h"
#include "Heston.h"

/** Spikes class
 * @brief falling sprites to be avoided 
 * @author Joe Body, University of Leeds
 * @date May 2020
 */   

class Spikes
{

public:

    /** Constructor */
    Spikes();
    
    /** Destructor */
    ~Spikes();
    
    /** Initalises Spikes*/
    void init();
    
    /** Draws the first type of spike
    * @param lcd @details N5110 object
    */
    void draw(N5110 &lcd);
    
    /** Draws the second type of spike
    * @param lcd @details N5110 object
    */
    void draw2(N5110 &lcd);
    
    /** Draws the third type of spike
    * @param lcd @details N5110 object
    */
    void draw3(N5110 &lcd);
    
    /** update the y direction */
    void updatey();
    
    /** update the x direction */
    void updatex();
    
    /** update the x direction negatively*/
    void updatexn();
    
    /** set initial random position of a spike 
    * @param int x @ details 1-4 determines general section of screen
    */
    void position(int x);
    
    /** set co ordinates of sprite 
    * @param int x 
    * @param int y 
    */
    void set_pos(int x, int y);
    
    /** gets co-ordinates of the sprite
    * @ return position vector  
    */
    Vector2D get_pos();
    
    /** set co ordinates of sprite 
    * @param pad @detail  Gampad object 
    */
    void hit(Gamepad &pad);
    
private:
    
    /**vertical size sprite
    * @return _height
    */
    int _height;
    
    /**horizontal size sprite
    * @return _height
    */
    int _width;
    
    /** x position of sprite
    * @return _x
    */
    int _x;
    
    /** y position of sprite
    * @return _y
    */
    int _y;
    
    /** speed of sprite
    * @return _speed
    */
    int _speed;

};


#endif