#ifndef PUP_H
#define PUP_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Aim.h"
#include "Heston.h"

/** Power up class
 * @brief clock to slow heston sprite
 * @author Joe Body, University of Leeds
 * @date May 2020
 */   

class Pup
{

public:

    /** Constructor */
    Pup();
    
    /** Destructor */
    ~Pup();
    
    /** Initalises Pup*/
    void init();
    /** Draws the first type of spike
    * @param lcd @details N5110 object
    */
    void draw(N5110 &lcd);
    
    /** set initial semi random random position of a clock based on cursor
    * @param int x
    * @param int y 
    */
    void position(int x, int y);
    
    /** gets co-ordinates of the sprite
    * @ return position vector  
    */
    Vector2D get_pos();
    
    /** set co ordinates of sprite 
    * @param int x 
    * @param int y 
    */
    void set_pos(int x, int y);
    
private:
    
    /**vertical size sprite
    * @return _height
    */
    int _height;
    
    /**horizontal size sprite
    * @return _height
    */
    int _width;
    
    /** x position of sprite
    * @return _x
    */
    int _x;
    
    /** y position of sprite
    * @return _y
    */
    int _y;

};

#endif