#ifndef HESTON_H
#define HESTON_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** Heston class
 * @brief moving sprite to be shot
 * @author Joe Body, University of Leeds
 * @date May 2020
 */   

class Heston
{

public:

    /** Constructor */
    Heston();
    
    /** Destructor */
    ~Heston();
    
    /** Initalises Heston*/
    void init();
    
    /** Draws the spike
    * @param lcd @details N5110 object
    */
    void draw(N5110 &lcd);
    
    /** update the position of the sprite in a random direction
    * @param pad @details Gamepad object
    */
    void update(Gamepad &pad);
// accessors and mutators

    /** gets co-ordinates of the sprite
    * @ return position vector  
    */
    Vector2D get_pos();
    
    /** set co ordinates of sprite 
    * @param int x 
    * @param int y 
    */
    void set_pos(int x, int y);
    
    /**moves spite and turns on leds if hit occurs
    * @param pad @details Gamepad object
    * @param int x 
    * @param int y 
    */
    void hit(Gamepad &pad, int x, int y);
    
    /** on leds if miss occurs
    * @param pad @details Gamepad object
    */
    void miss(Gamepad &pad);
    
    /** checks current score
    * @return Score
    */
    int checkscore();
    
    /** checks current strikes
    * @return strike
    */
    int checkstrike();
    
    /** increase or decrease speed that sprite is moving */
    void set_speed(int state);
    
    /** decrease strike by 5 */
    void negfive();
    
private:

    /**vertical size sprite
    * @return _height
    */
    int _height;
    
    /**horizontal size sprite
    * @return _height
    */
    int _width;
    
    /** x position of sprite
    * @return _x
    */
    int _x;
    
    /** y position of sprite
    * @return _y
    */
    int _y;
    
    
    /** speed of sprite
    * @return _speed
    */
    int _speed;
    
    /** current score */
    int score;
    
    /** current number of strikes left */
    int strike;

};
#endif