#ifndef ENG_TEST_H
#define ENG_TEST_H
 
/** Engine Test
 * @brief positioning and gameplay tests
 * @author Jospeh Body, University of Leeds
 * @date May 2020
 * @return true if test are passed 
 */
bool collision_hest_test()
{
    // Initialise 
    Aim aim;
    aim.init(); //_x = 42 _y = 5
    Gamepad pad;
    N5110 lcd;
    Heston heston;
    heston.init();
    
    aim.set_pos(33, 33);
    heston.set_pos(33, 33);

    // Read the position
    Vector2D aim_pos = aim.get_pos();
    printf("%f, %f\n", aim_pos.x, aim_pos.y);
    Vector2D hest_pos = heston.get_pos();
    printf("%f, %f\n", hest_pos.x, hest_pos.y);

    
    // Now check that both the position is as expected
    bool success_flag = false;
    
    // Fail the test if the initial position is wrong
    if ( (aim_pos.x - 2 == hest_pos.x) || (aim_pos.y - 2 == hest_pos.y) ){// -2 as taking the position of the cursur to be the center not top left
        success_flag = true;
    }

    return success_flag;
}

bool collision_pup_test()
{
    // Initialise 
    Aim aim;
    aim.init(); //_x = 42 _y = 5
    Gamepad pad;
    N5110 lcd;
    Pup pup;
    pup.init();

    
    aim.set_pos(33, 33);
    pup.set_pos(33, 33);

    // Read the position
    Vector2D aim_pos = aim.get_pos();
    printf("%f, %f\n", aim_pos.x, aim_pos.y);
    Vector2D pup_pos = pup.get_pos();
    printf("%f, %f\n", pup_pos.x, pup_pos.y);

    
    // Now check that both the position is as expected
    bool success_flag = false;
    
    // Fail the test if the initial position is wrong
    if (aim_pos.x - 2 == pup_pos.x || aim_pos.y - 2 == pup_pos.y) {// -2 as taking the position of the cursur to be the center not top left
        success_flag = true;
    }

    return success_flag;
}


bool collision_spike_test()
{
    // Initialise 
    Aim aim;
    aim.init(); //_x = 42 _y = 5
    Gamepad pad;
    N5110 lcd;
    Spikes spikes;
    spikes.init();

    
    aim.set_pos(33, 33);
    spikes.set_pos(33, 33);

    // Read the position
    Vector2D aim_pos = aim.get_pos();
    printf("%f, %f\n", aim_pos.x, aim_pos.y);
    Vector2D spikes_pos = spikes.get_pos();
    printf("%f, %f\n", spikes_pos.x, spikes_pos.y);

    
    // Now check that both the position is as expected
    bool success_flag = false;
    
    // Fail the test if the initial position is wrong
    if (aim_pos.x - 2 == spikes_pos.x || aim_pos.y - 2 == spikes_pos.y) {// -2 as taking the position of the cursur to be the center not top left
        success_flag = true;
    }

    return success_flag;
}

#endif