#ifndef ENG_H
#define ENG_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Aim.h"
#include "Heston.h"
#include "Pup.h"
#include "Spikes.h"
#include "Highscore.h"
#include "SDFileSystem.h"
#include "Sound.h"


/** Game Engine class
 * @brief all the basic interations on the game
 * @author Joe Body, University of Leeds
 * @date May 2020
 */
 
 
class Eng
{

public:

    /** Constructor */
    Eng();
    
    /** Destructor */
    ~Eng();
    
    /** Initalises GameEngine */
    void init();
    
    /** update the parts of the game*/
    void update(Gamepad &pad, int fire, N5110 &lcd, FXOS8700CQ &acc);
    
    /** draw parts of the game 
    * @param lcd @details N5110 object */
    void draw(N5110 &lcd);
    
    /** print score
    * @param lcd @details N5110 object*/ 
    void print_score(N5110 &lcd);
    
    /** print strike
    * @param lcd @details N5110 object*/ 
    void print_strike(N5110 &lcd);
    
    /** checks value of strike
    * @param lcd @details N5110 object
    * @return number of strikes*/ 
    int checkgame(N5110 &lcd);
    
    /** checks value of strike
    * @param lcd @details N5110 object 
    * @param pad @details Gamepad object
    * @param hs @details Highscore object
    * @param sd @details SD file system object
    */
    void gameover(N5110 &lcd, Gamepad &pad, Highscore &hs, SDFileSystem &sd);
    
    /** basic ticker to determine when spikes spawn */
    void tik();
    
    /** "spike mode" mini round
    * @param lcd @details N5110 object 
    * @param pad @details Gamepad object
    * @param acc @details Accelerometer object
    */
    void spikemode(N5110 &lcd, Gamepad &pad, FXOS8700CQ &acc);
    
    /** check spike collision during spike mode
    * @param pad @details Gamepad object
    */
    int check_sm_hit(Gamepad &pad);
    
private:

    void check_hit(Gamepad &pad, N5110 &lcd);
    
    /** set power up flag and pass aim position
    * @param pad @details Gamepad object
    * @param lcd @details N5110 object 
    */
    void powerup(N5110 &lcd, Gamepad &pad);
    
    /** check spike collision
    * @param pad @details Gamepad object
    * @param lcd @details N5110 object 
    */
    void check_s_hit(Gamepad &pad, N5110 &lcd, FXOS8700CQ &acc);
    
    /** power up draw flag */
    int pupon;
    
    /** time incrementer*/
    int _tok;
    
    /** power up flag */
    bool flag;
    
    /** spike flag */
    bool spike_f; 
    
    //objects
    
    /** aim object */
    Aim _aim;
    
    /** Heston object */    
    Heston _h1;
    
    /** powerup object object */
    Pup _pup;
    
    /** spike 1 */   
    Spikes _s1;
    /** spike 2 */ 
    Spikes _s2;
    /** spike 3 */ 
    Spikes _s3;
    /** spike 4 */ 
    Spikes _s4;
    

};

#endif