
#include "Eng.h"

Eng::Eng()
{

}

Eng::~Eng()
{

}
// objects
//Gamepad pad;
//N5110 lcd;
Aim aim;
Heston heston;
Pup pup;
Spikes spikes;



void Eng::init()
{
    
    aim.init();
    heston.init();
    pup.init();
    spikes.init();
    pupon = 0;
    _tok = 0;
    flag = true;
    spike_f =false;
    


}


void Eng::update(Gamepad &pad, int fire, N5110 &lcd, FXOS8700CQ &acc)
{
        int shot = fire;
        if (shot == 1){
            aim.draw(lcd, fire);
            //printf("shot =  %f\n", shot);
            lcd.refresh();
            check_hit(pad, lcd);   
        }
        
        int strikes = heston.checkstrike();
        //printf("strike =  %d\n", strike);
        
        
        int c_score = heston.checkscore();
        //printf("score =  %d\n", score);
        if (c_score%5 == 0 && flag == false){//spkie flag wont activate immedietly
            flag = true;
            powerup(lcd, pad);
        }
        if (c_score%5 == 1){
            flag = false;
        }
        
        if (spike_f == true){
            //spikes.update();
            _s1.updatey();
            _s2.updatey();
            check_s_hit(pad, lcd, acc);
        }
        
        heston.update(pad);
        aim.update(pad);
        
        
}

void Eng::draw(N5110 &lcd)
{
    heston.draw(lcd);
    aim.draw(lcd, 0);
    if (pupon == 1){
        pup.draw(lcd);
    }
    if (spike_f == true){
        _s1.draw(lcd);
        _s2.draw(lcd);
    }
    
}

void Eng::check_hit(Gamepad &pad, N5110 &lcd)
{
    Vector2D aim_pos = aim.get_pos();
    Vector2D h1_pos = heston.get_pos();
    Vector2D pup_pos = pup.get_pos();
    
    if (
        (aim_pos.y >= h1_pos.y) && //top
        (aim_pos.y <= h1_pos.y + 10) && //bottom
        (aim_pos.x >= h1_pos.x) && //left
        (aim_pos.x <= h1_pos.x + 10)  //right
    ) {
        pad.play_melody(5, hit_sound, hit_dur, 300, false);
        heston.hit(pad, aim_pos.x, aim_pos.y);
        print_score(lcd);
        lcd.refresh();
    }
    else if (
        (pupon == 1) &&
        (aim_pos.y >= pup_pos.y) && //top
        (aim_pos.y <= pup_pos.y + 8) && //bottom
        (aim_pos.x >= pup_pos.x) && //left
        (aim_pos.x <= pup_pos.x + 8)  //right
    ) {
        pad.play_melody(5, pup_sound, pup_dur, 300, false);
        pupon = 0;
        heston.set_speed(0);
        pad.led(2,1);
        pad.led(5,1);
    }
    else {
        pad.play_melody(5, miss_sound, miss_dur, 300, false);
        heston.miss(pad);
        print_strike(lcd);
        lcd.refresh();
        }
wait(0.4);
pad.leds_off();
}

void Eng::powerup(N5110 &lcd, Gamepad &pad)
{
    Vector2D aim_pos = aim.get_pos();
    int x = aim_pos.x;
    int y = aim_pos.y;
    pup.position(x, y);//pass in curren cursor position
    pupon = 1;
}

void Eng::tik()
{
    _tok = _tok + 1;
    int rem = _tok%50;
    //printf("remainder =  %d\n", rem);
    if (rem == 0){
        heston.set_speed(1);
        spike_f = true;
        _s1.position(1);
        _s2.position(2);
    }
}

void Eng::print_strike(N5110 &lcd)
{
    // get scores from heston class
    int g_score = heston.checkstrike();
 
    // print to LCD i
    char buffer1[14];
    sprintf(buffer1,"%2d",g_score);
    lcd.printString(buffer1,0,0);  // 
}   

void Eng::print_score(N5110 &lcd)
{
    // get scores from sprite
    int g_score = heston.checkscore();
 
 
    // print to LCD i
    char buffer1[14];
    sprintf(buffer1,"%2d",g_score);
    lcd.printString(buffer1,70,0);  // font is 8 wide, so leave 4 pixel gape from middle assuming two digits
}   

void Eng::check_s_hit(Gamepad &pad, N5110 &lcd, FXOS8700CQ &acc){
    Vector2D s1_pos = _s1.get_pos();
    Vector2D s2_pos = _s2.get_pos();
    Vector2D aim_pos = aim.get_pos();
    
    if (//collision counted across the entire hieght and witdth of both sprites not just the center
        (aim_pos.y + 2 >= s1_pos.y) && //top
        (aim_pos.y - 2 <= s1_pos.y + 4) && //bottom
        (aim_pos.x + 2 >= s1_pos.x) && //left
        (aim_pos.x - 2 <= s1_pos.x + 4)  //right
        ) {
         pad.play_melody(5, spike_sound, spike_dur, 300, false);
         spikes.hit(pad);
         spikemode(lcd, pad, acc);
         spike_f = false;
    }
    if (
        (aim_pos.y + 2 >= s2_pos.y) && //top
        (aim_pos.y - 2 <= s2_pos.y + 4) && //bottom
        (aim_pos.x + 2 >= s2_pos.x) && //left
        (aim_pos.x - 2 <= s2_pos.x + 4)  //right
        ) {
         pad.play_melody(5, spike_sound, spike_dur, 300, false);
         spikes.hit(pad);
         spikemode(lcd, pad, acc);
         spike_f = false;
    }
         
         
}

int Eng::checkgame(N5110 &lcd)
{
    int x = 0;
    int value = heston.checkstrike();
    if (value <= 0){
        x = 1;
    }
    return x;
}

void Eng::gameover(N5110 &lcd, Gamepad &pad, Highscore &hs, SDFileSystem &sd)
{
    while ( pad.B_held() == false) {//press b to return to menu to play again
        int value = heston.checkscore();
        char buffer1[14];
        sprintf(buffer1,"%2d",value);
        lcd.clear();
        int highs = hs.geths(sd);
        //printf("read =  %d \n", highs);
        if (value >= highs){
            hs.seths(sd, value);
            lcd.printString("   Game Over  ",0,0);
            lcd.printString("  Highscore!  ",0,2);
            lcd.printString(buffer1,38,3);//as central as posible
            lcd.printString(" Menu Press B ",0,5);
        }
        else {    
        lcd.printString("   Game Over  ",0,0);
        lcd.printString("     Score    ",0,2);
        lcd.printString(buffer1,38,3);
        lcd.printString(" Menu Press B ",0,5);
        }
        
        
        lcd.refresh();
        wait(0.1);
    }
}

void Eng::spikemode(N5110 &lcd, Gamepad &pad, FXOS8700CQ &acc)
{

    _s1.position(1);
    _s2.position(2);
    _s3.position(3);
    _s4.position(4);
    aim.update(pad);
    int kill = 0;
    while (1){
        wait(0.1);
        lcd.clear();
        //aim.update(pad);
        aim.acc_control(acc);
        _s1.updatey();
        _s2.updatey();
        _s3.updatexn();
        _s4.updatex();
        aim.draw(lcd, 1);
        _s1.draw(lcd);
        _s2.draw(lcd);
        _s3.draw3(lcd);
        _s4.draw2(lcd);
        lcd.refresh();
        
        kill = check_sm_hit(pad);
        Vector2D s4_pos = _s4.get_pos();
        if (kill == 1){
            heston.negfive();
            break;
        } if (s4_pos.x >= 84){//run until hit by spike or all spikes have run the length of the screen
            break;
        }
    }
        
}
        
int Eng::check_sm_hit(Gamepad &pad)
{
    Vector2D s1_pos = _s1.get_pos();
    Vector2D s2_pos = _s2.get_pos();
    Vector2D s3_pos = _s3.get_pos();
    Vector2D s4_pos = _s4.get_pos();
    Vector2D aim_pos = aim.get_pos();
    
    if (//collision counted across the entire hieght and witdth of cursor
        (aim_pos.y + 2 >= s1_pos.y) && //top
        (aim_pos.y - 2 <= s1_pos.y + 4) && //bottom
        (aim_pos.x + 2 >= s1_pos.x) && //left
        (aim_pos.x - 2 <= s1_pos.x + 4)  //right
        ) {
         pad.play_melody(5, spike_sound, spike_dur, 300, false);
         spikes.hit(pad);
         return 1;
         
    }
    if (
        (aim_pos.y + 2 >= s2_pos.y) && //top
        (aim_pos.y - 2 <= s2_pos.y + 4) && //bottom
        (aim_pos.x + 2 >= s2_pos.x) && //left
        (aim_pos.x - 2 <= s2_pos.x + 4)  //right
        ) {
         pad.play_melody(5, spike_sound, spike_dur, 300, false);
         spikes.hit(pad);
         return 1;
    }
    if (
        (aim_pos.y + 2 >= s3_pos.y) && //top
        (aim_pos.y - 2 <= s3_pos.y + 4) && //bottom
        (aim_pos.x + 2 >= s3_pos.x) && //left
        (aim_pos.x - 2 <= s3_pos.x + 4)  //right
        ) {
         pad.play_melody(5, spike_sound, spike_dur, 300, false);
         spikes.hit(pad);
         return 1;
    }
    if (
        (aim_pos.y + 2 >= s4_pos.y) && //top
        (aim_pos.y - 2 <= s4_pos.y + 4) && //bottom
        (aim_pos.x + 2 >= s4_pos.x) && //left
        (aim_pos.x - 2 <= s4_pos.x + 4)  //right
        ) {
         pad.play_melody(5, spike_sound, spike_dur, 300, false);
         spikes.hit(pad);
         return 1;
    }
    else {
        return 0;
    }
}       
    
