#ifndef ENEMY_H
#define ENEMY_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Bitmap.h"
 
#define TYPE_VERT 1
#define TYPE_HOR 0

/** Enemy Class
 * @brief Class to control the enemies
 * @author Joe Barhouch
 * @author 201291584
 */
class Enemy
{

public:
    /** Constructor 
    *@param Horizontal or Vertical enemy
    *@param intial X
    *@param intial Y
    */
    Enemy(bool type,int spawnX, int spawnY);
    /** Deconstructor */
    ~Enemy();
    /** Draw on the lcd
    *@param lcd
    */
    void draw(N5110 &lcd);
        /** update speed
    *@param set int speed
    */
    void update(int _ev);
    /** set position of enemies
    *@param X coordinate
    *@param Y coordinate
    */
    void set_pos(int x, int y);
    /** set position of enemies
    *@return Vector2D of the position
    */
    Vector2D get_pos();


private:
    
    void drawVertical(N5110 &lcd);
    void drawHoriz(N5110 &lcd);
    bool _type;
    int _enX;
    int _enY;
    
    bool xDir;
    bool yDir;
};


#endif