/*
ELEC2645 Embedded Systems Project
School of Electronic & Electrical Engineering
University of Leeds
2019/20

Name: Joe Barhouch
Username: el18jb
Student ID Number: 201291584
*/

// includes
#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "Bitmap.h"
#include "Player.h"
#include "Engine.h"

int intro[] = {
    1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,
    1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,
    1,1,1,0,1,0,1,0,0,0,0,1,0,1,0,1,1,1,
    1,1,1,0,1,0,1,1,1,1,1,1,0,1,0,1,1,1,
    1,1,1,0,1,0,1,1,0,0,1,1,0,1,0,1,1,1,
    1,1,1,1,1,1,1,0,0,0,1,1,1,1,1,1,1,1,
    0,1,1,0,1,1,0,0,0,0,0,0,1,1,0,1,1,0,
    0,1,1,0,1,1,0,0,0,0,0,0,1,1,0,1,1,0,
    1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,
    1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,
    1,1,1,0,1,0,1,0,0,0,0,1,0,1,0,1,1,1,
    1,1,1,0,1,0,1,1,1,1,1,1,0,1,0,1,1,1,
    1,1,1,0,1,0,1,1,0,0,1,1,0,1,0,1,1,1,
    1,1,1,1,1,1,1,0,0,0,1,1,1,1,1,1,1,1,
    0,1,1,0,1,1,0,0,0,0,0,0,1,1,0,1,1,0,
    0,1,1,0,1,1,0,0,0,0,0,0,1,1,0,1,1,0,
};
Bitmap introo(intro, 16,18);
// objects
Gamepad pad;
N5110 lcd;
Player player;
Engine engine;

// input
struct UserInput {
    Direction d;
    float mag;
};

// function prototypes
void init();
void display();

// variables
bool gameState = 0;
Timer T;
bool pause = 1;
bool i=0;
int fps;

int main()
{


    init();
    char buffer[14];
    int fps = 10;  // frames per second
    while(pause == 1 ) {
        lcd.clear();
        if(i == 0) {
            lcd.normalMode();
            lcd.clear();
            introo.render(lcd, 33,16);
            sprintf(buffer,"A for Hard, B for Easy");
            lcd.printString(buffer,10,40);
            lcd.refresh();
            if( pad.A_pressed() ){
            pause =0;
            fps = 13;
        } else if(pad.B_pressed() ){
            pause =0;
            fps = 10;
        }
    }
    }
    display();  // first draw the initial frame
        wait(1.0f/fps);  // and wait for one frame period
        // game loop

        while (gameState == 0) {
            T.start();
            srand(T);
            lcd.setContrast( pad.read_pot1()); //contrast set by pot1
            engine.read_input(pad);            //reads input from pad
            engine.update(pad);                //update physics and calculations
            display();                         //display on screen
            wait(1.0f/fps);                    //wait for fps
            gameState = engine.koed();
        }
            engine.gameOver(lcd);
            lcd.clear();
            int Score = engine.getScore();
            lcd.normalMode();
            sprintf(buffer,"Your score is: %i", Score);
            lcd.printString(buffer,10,40);
            lcd.refresh();
            
        if(pad.A_pressed() || pad.B_pressed() || pad.X_pressed() || pad.Y_pressed() ||pad.start_pressed()){
                gameState=1; //restart
            }
    }
//initialisation
    void init() {
        lcd.init();
        pad.init();
        engine.init();
    }

//display function by clearing, updating and refreshing
    void display() {
        lcd.clear();
        engine.draw(lcd);
        lcd.refresh();
    }


