#include "Player.h"
#include "Sprites.h"

Player::Player()
{

}

Player::~Player()
{

}

//initialize
void Player::init(int x,int y)
{
    _playerX = x;
    _playerY = y;
}





//Draw the sprites depending on the orientation
void Player::draw(N5110 &lcd)
{
    if(_dir == E) {
        Bitmap bit_player(s_player, 8, 9);
        bit_player.render(lcd, _playerX, _playerY);
    }

    if(_dir == W) {
        Bitmap bit_player_inv(s_player_inv, 8, 9);
        bit_player_inv.render(lcd, _playerX, _playerY);
    } else {
        Bitmap bit_player(s_player, 8, 9);
        bit_player.render(lcd, _playerX, _playerY);
    }
}

//Update player movement and set screen restrictions
void Player::update(Direction d, float mag, int Ypos, bool fall, bool jump)
{
    _vx = int(mag*4.0f);
    //GO RIGHT
    if(d == E) {
        _playerX = _playerX + _vx;
        _dir = E;
    }
    //GO LEFT
    if(d == W) {
        _playerX = _playerX - _vx;
        _dir = W;
    }

    switch(jump) {
        case 0:
            //FREE FALL
            if( fall == true) {
                _playerY = _playerY + GRAVITY ;
            }

            //FLOOR COLLISION
            if ( fall == false) {
                _playerY  = Ypos;
            }
            break;

        case 1:
            //JUMP UNTIL TWICE PLAYER HEIGHT
            _playerY -= GRAVITY +1;

            break;

    }

//SCREEN RESTRICTIONS
    if (_playerX > WIDTH - 9) {
        _playerX = WIDTH - 9;
    }
    if(_playerX < 0) {
        _playerX = 0;
    }



//debug
//printf("x: %i, y: %i \n", _playerX, _playerY);
}

//get the position of the player in a 2D vector
Vector2D Player::get_pos()
{
    Vector2D pos = {_playerX, _playerY};
    return pos;
}


