#include "Engine.h"

Platform maps[7] = {Platform(0, 10, 20, 3), Platform(70, 14, 14, 3), Platform(40, 25, 30, 3), Platform(65, 44, 15, 3), Platform(5, 35, 20, 3), Platform(25, 17, 5, 3),Platform(40, 40, 10, 3)};
int mapSize = sizeof(maps)/sizeof(*maps);


////////////////////// DRAW MAP //////////////////////////
void drawMap(N5110 &lcd)
{
    for (int i = 0; i < mapSize; i++) {
        maps[i].draw(lcd);

        //debugs
        //coords = maps[i].get_pos();
        //printf("x: %i, y: %i,w: %i,h: %i \n",coords.x, coords.y, coords.width, coords.height);
    }
    //debugs
    //printf("-----------------------------------------\n");
}



Engine::Engine()
{
}
Engine::~Engine()
{
}


////////////////////// INIT ////////////////////////////
void Engine::init()
{
    t.start();

    //init coord
    _px = WIDTH / 2;
    _py = 5;

    //init call
    _p.init(_px, _py);

    //ennemy
    enemies.push_back(Enemy(0,0, 10));
    enemies.push_back(Enemy(0,75, 20));
    enemies.push_back(Enemy(1,20, 0));
    enemies.push_back(Enemy(1,60, 30));
    ko1 = 0;
    ko2 = 0;

    //physics parameters
    _Ypos = 0;
    _fall = true;
    _c = false;

    //coins
    coin.init();
        middlesX.push_back(10);
        middlesX.push_back(77);
        middlesX.push_back(55);
        middlesX.push_back(72);
        middlesX.push_back(16);
        middlesX.push_back(27);
        middlesX.push_back(45);
        //{10, 77, 55, 72, 15, 27, 45};
        
        middlesY.push_back(6);
        middlesY.push_back(10);
        middlesY.push_back(21);
        middlesY.push_back(40);
        middlesY.push_back(30);
        middlesY.push_back(13);
        middlesY.push_back(36);
        
     //{6, 10, 21, 40, 30, 13, 36};

    //counter
    counter =0;
    score = 0;

}



////////////////////// INPUT //////////////////////////
//reads direction and magnitude from the JOYSTICK to control the player
void Engine::read_input(Gamepad &pad)
{
    _d = pad.get_direction();
    _mag = pad.get_mag();
    _jump = pad.B_held();
    //printf("%s", _jump ? "true\n" : "false\n");
}





////////////////////// DRAW ///////////////////////////
//draw both player and map
void Engine::draw(N5110 &lcd)
{
    _p.draw(lcd);   // player
    drawMap(lcd);   // map
    for(int i = 0; i < enemies.size(); i ++) { //enemies
        enemies.at(i).draw(lcd);
    }
    coin.draw(lcd); //coin

}




////////////////////// UPDATE //////////////////////////
//provide the player file with necessary Joystick values
//updates enemy file
void Engine::update(Gamepad &pad)
{
    f = rand()%7+1;
    fellDown();
    coinTaken(pad);
    coin.show(pad);
    floorCollide();
    enemyCollide();
    _p.update(_d,_mag, _Ypos, _fall, _jump);

    for(int i = 0; i < enemies.size(); i ++) {
        enemies.at(i).update(2);
    }
    score =  getScore();

}


/*
    if (_c == true) {

        //debug
        //printf("collison\n");
    } else {

        //debug
        //printf("no collison\n");
    }
    //enemmyCollide(pad);
}
*/

///////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////
                        //COLLISIONS//


////////////////////// FLOOR COLLISION //////////////////////////
void Engine::floorCollide()
{
    int a;
    Vector4 coords[mapSize];
    player = _p.get_pos();
    //coordinates of platforms
    for(int i = 0; i < mapSize; i++) {
        coords[i] = maps[i].get_pos();
    }


    if(_c == false) {
        _fall = true;
        for(int j=0; j < mapSize; j++) {
            if(player.x+5 >= coords[j].x  && player.x+1 <= coords[j].x + coords[j].width  && player.y+9 >= coords[j].y  && player.y+9 <= coords[j].y + coords[j].height) {
                a = j;
                _c = true;
                //printf("%i, %i\n", player.x, player.y );
            }
        }
    }

    if(_c == true) {
        _Ypos = coords[a].y - 8;
        _fall = false;
        _c = false;
    }
}


//////////////////////get score /////////////////////////
int Engine::getScore(){
        return counter;
    }
    


////////////////////// GOT COIN /////////////////////////////////////////
void Engine::coinTaken(Gamepad &pad)
{

    //rands
    //srand((unsigned) time(NULL));

    coinPos = coin.get_pos();
    if(player.x+4 >= coinPos.x-2 & player.y+4 >= coinPos.y-2 & player.x+4 <= coinPos.x+2 & player.y+4 <= coinPos.x+2 || pad.A_pressed()) {
        //printf("%i, %i\n",x[f], y[f]);
        coin.set_pos(middlesX.at(f), middlesY.at(f));
        //printf("TAKEN\n");
        //printf("%i\n", f);
        pad.tone(600, 0.15);
        counter++;
    }
}






///////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////
                        //DEATHS//


////////////////////// ENNEMY COLLIDE ///////////////////////////////////
bool Engine::enemyCollide()
{
    vector <Vector2D> epos;
    for (int i = 0; i < enemies.size(); i++) {
        epos.push_back(enemies.at(i).get_pos());
        //printf("coord %i, at %f, %f\n", i, epos.at(i).x, epos.at(i).y);
    }
    for (int i=0; i<epos.size(); i++) {
        if(player.x < epos.at(i).x + 7  && player.y < epos.at(i).y + 5 && player.x+9 > epos.at(i).x && player.y> epos.at(i).y) {
            ko1 = 1;
            //printf("KO\n");
        }
    }
    return ko1;
}

///////////////////// FELL DOWN /////////////////////////////////////////////
bool Engine::fellDown()
{
    if(player.y > HEIGHT - 2) {
        ko2 = 1;
    }  else {
        ko2 = 0;
    }
    return ko2;
}


/////////////////////// KO ///////////////////////////////////////////////////
bool Engine::koed()
{
    if( ko1 == 1 || ko2 == 1) {
        return true;
    } else {
        return false;
    }
}


////////////////////// GAME OVER ///////////////////////////////////////////
void Engine::gameOver(N5110 &lcd)
{
    lcd.inverseMode();
    wait(0.5);
    lcd.normalMode();
    wait(0.5);
    lcd.inverseMode();
    wait(0.5);
    //printf("KO RUN\n");
}


