#ifndef COIN_H
#define COIN_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
/** Coin Class
 * @brief Class to control the coins
 * @author Joe Barhouch
 * @author 201291584
 */
class Coin
{
public:
    /** Constructor */
    Coin();
    /** Deconstructor */
    ~Coin();
    /** Initialise coordinates to the middle of the screen*/
    void init();
    /** Draw on the lcd
    *@param lcd
    */
    void draw(N5110 &lcd);
    /** Display coin position with LEDS
    *@param pad
    */
    void show(Gamepad &pad);
    /** Get position 
    *@return Vector2D of the Position
    */
    Vector2D get_pos();
    /** Set position
     *@param X coordinate
     *@param Y coordinate
     */
    void set_pos(int X, int Y);

private:
    bool side;
    bool taken;
    int _x;
    int _y;

};

#endif